<?php 

if (! defined('WPINC') ) {
	die;
}

if ( !class_exists( 'Addify_Product_Videos_Admin' ) ) {

	class Addify_Product_Videos_Admin extends Addify_Product_Videos {

		public function __construct() {

			add_action( 'admin_enqueue_scripts', array( $this, 'afpv_admin_scripts' ) );
			add_action( 'admin_menu', array( $this, 'afpv_custom_menu_admin' ) );
			add_action('admin_init', array($this, 'afpv_options'));
			add_action( 'admin_init', array( $this, 'afpv_vidoes_metaboxes' ), 10 );
			add_action( 'save_post', array($this, 'afpv_meta_box_save' ));

			add_filter( 'manage_af_product_videos_posts_columns', array( $this, 'afpv_custom_columns' ) );
			add_action( 'manage_af_product_videos_posts_custom_column' , array($this, 'afpv_custom_column'), 10, 2 );
		}

		public function afpv_admin_scripts() { 
			
			wp_enqueue_style( 'afpv-admin', plugins_url( '/css/afpv_admin.css', __FILE__ ), false, '1.0' );
			wp_enqueue_style( 'select2', plugins_url( '/css/select2.css', __FILE__ ), false, '1.0' );
			wp_enqueue_script( 'select2', plugins_url( '/js/select2.js', __FILE__ ), false, '1.0' );
			wp_enqueue_script( 'afpv-admin', plugins_url( '/js/afpv_admin.js', __FILE__ ), false, '1.0' );
			wp_enqueue_style('thickbox');
			wp_enqueue_script('thickbox');
			wp_enqueue_script('media-upload'); 
			wp_enqueue_media();
			
		}

		public function afpv_custom_menu_admin() {    
			
			add_submenu_page(
				'edit.php?post_type=af_product_videos',
				esc_html__( 'Settings', 'addify_videos' ),
				esc_html__( 'Settings', 'addify_videos' ),
				'manage_options',
				'afpv-settings',
				array($this, 'afpv_settings_page')
			);
		}

		public function afpv_custom_columns( $columns) {

			unset($columns['date']);
			$columns['afpv_video_type'] = esc_html__( 'Video Type', 'addify_videos' );
			$columns['date']            = esc_html__( 'Date Published', 'addify_videos' );

			return $columns;
		}

		public function afpv_custom_column( $column, $post_id ) {
			$afrfq_post = get_post($post_id);
			switch ( $column ) {
				case 'afpv_video_type':
					$afpv_video_type = get_post_meta($post_id, 'afpv_product_video_type', true);
					
					echo esc_attr( $afpv_video_type );

					break;
			}
		}

		public function afpv_settings_page() {

			if ( isset( $_GET[ 'tab' ] ) ) {  
				$active_tab = sanitize_text_field( $_GET[ 'tab' ]);  
			} else {
				$active_tab = 'tab_one';
			}
			?>
				<div class="wrap">
					<h2><?php echo esc_html__('Product Videos Settings', 'addify_videos'); ?></h2>
					<?php settings_errors(); ?> 

					<h2 class="nav-tab-wrapper">  
					
						<a href="?post_type=af_product_videos&page=afpv-settings&tab=tab_one" class="nav-tab <?php echo esc_attr($active_tab) == 'tab_one' ? 'nav-tab-active' : ''; ?>"><?php echo esc_html__('Self Hosted (Featured Video)', 'addify_videos'); ?></a> 
						<a href="?post_type=af_product_videos&page=afpv-settings&tab=tab_two" class="nav-tab <?php echo esc_attr($active_tab) == 'tab_two' ? 'nav-tab-active' : ''; ?>"><?php echo esc_html__('Third Party (Featured Video)', 'addify_videos'); ?></a> 

						
						<a href="?post_type=af_product_videos&page=afpv-settings&tab=tab_four" class="nav-tab <?php echo esc_attr($active_tab) == 'tab_four' ? 'nav-tab-active' : ''; ?>"><?php echo esc_html__('Third Party (Video Gallery)', 'addify_videos'); ?></a> 
						<a href="?post_type=af_product_videos&page=afpv-settings&tab=tab_five" class="nav-tab <?php echo esc_attr($active_tab) == 'tab_five' ? 'nav-tab-active' : ''; ?>"><?php echo esc_html__('Elementor/Divi Builder Compatibility', 'addify_videos'); ?></a> 
					</h2>

					<form method="post" action="options.php"> 
						<?php
						if ( 'tab_one' == $active_tab ) {  
							settings_fields( 'setting-group-1' );
							do_settings_sections( 'addify-product-videos-1' );
						} 

						if ( 'tab_two' == $active_tab ) {  
							settings_fields( 'setting-group-2' );
							do_settings_sections( 'addify-product-videos-2' );
						} 


						if ( 'tab_four' == $active_tab ) {  
							settings_fields( 'setting-group-4' );
							do_settings_sections( 'addify-product-videos-4' );
						}
						if ( 'tab_five' == $active_tab ) {  
							settings_fields( 'setting-group-5' );
							do_settings_sections( 'addify-product-videos-5' );
						} 
						?>
						<?php submit_button(); ?> 
					</form> 

				</div>
			<?php 

		}

		public function afpv_options() {

			add_settings_section(  
				'page_1_section',         // ID used to identify this section and with which to register options  
				'',   // Title to be displayed on the administration page  
				array($this, 'afpv_page_1_section_callback'), // Callback used to render the description of the section  
				'addify-product-videos-1'                           // Page on which to add this section of options  
			);

			add_settings_field(   
				'pv_featured_enable_auto_play',                      // ID used to identify the field throughout the theme  
				esc_html__('Auto Play Video', 'addify_videos'),                           // The label to the left of the option interface element
				array($this, 'afpv_featured_enable_auto_play_callback'),   // The name of the function responsible for rendering the option interface
				'addify-product-videos-1',                          // The page on which this option will be displayed  
				'page_1_section',         // The name of the section to which this field belongs  
				array(                              // The array of arguments to pass to the callback. In this case, just a description.  
					esc_html__('Allow or Disallow auto play of featured video.', 'addify_videos'),
				)  
			);  
			register_setting(  
				'setting-group-1',  
				'pv_featured_enable_auto_play'  
			);

			add_settings_field(   
				'pv_featured_enable_is_loop',                      // ID used to identify the field throughout the theme  
				esc_html__('Is Loop', 'addify_videos'),                           // The label to the left of the option interface element
				array($this, 'afpv_featured_enable_is_loop_callback'),   // The name of the function responsible for rendering the option interface
				'addify-product-videos-1',                          // The page on which this option will be displayed  
				'page_1_section',         // The name of the section to which this field belongs  
				array(                              // The array of arguments to pass to the callback. In this case, just a description.  
					esc_html__('Play video in loop.', 'addify_videos'),
				)  
			);  
			register_setting(  
				'setting-group-1',  
				'pv_featured_enable_is_loop'  
			);

			add_settings_field(   
				'pv_featured_enable_is_mute',                      // ID used to identify the field throughout the theme  
				esc_html__('Mute Video', 'addify_videos'),                           // The label to the left of the option interface element
				array($this, 'afpv_featured_enable_is_mute_callback'),   // The name of the function responsible for rendering the option interface
				'addify-product-videos-1',                          // The page on which this option will be displayed  
				'page_1_section',         // The name of the section to which this field belongs  
				array(                              // The array of arguments to pass to the callback. In this case, just a description.  
					esc_html__('If this option is set to yes, video is muted by defualt.', 'addify_videos'),
				)  
			);  
			register_setting(  
				'setting-group-1',  
				'pv_featured_enable_is_mute'  
			);

			add_settings_field(   
				'pv_featured_enable_video_controls',                      // ID used to identify the field throughout the theme  
				esc_html__('Show Video Controls', 'addify_videos'),                           // The label to the left of the option interface element
				array($this, 'afpv_featured_enable_video_controls_callback'),   // The name of the function responsible for rendering the option interface
				'addify-product-videos-1',                          // The page on which this option will be displayed  
				'page_1_section',         // The name of the section to which this field belongs  
				array(                              // The array of arguments to pass to the callback. In this case, just a description.  
					esc_html__('Show / Hide video controls on the video.', 'addify_videos'),
				)  
			);  
			register_setting(  
				'setting-group-1',  
				'pv_featured_enable_video_controls'  
			);

			add_settings_field(   
				'pv_featured_video_width_shop_page',                      // ID used to identify the field throughout the theme  
				esc_html__('Video/Thumbnail Width(Shop Page)', 'addify_videos'),                           // The label to the left of the option interface element
				array($this, 'afpv_featured_video_width_shop_page_callback'),   // The name of the function responsible for rendering the option interface
				'addify-product-videos-1',                          // The page on which this option will be displayed  
				'page_1_section',         // The name of the section to which this field belongs  
				array(                              // The array of arguments to pass to the callback. In this case, just a description.  
					esc_html__('Widht of the featured video or video thumbnail on shop page.', 'addify_videos'),
				)  
			);  
			register_setting(  
				'setting-group-1',  
				'pv_featured_video_width_shop_page'  
			);

			add_settings_field(   
				'pv_featured_video_height_shop_page',                      // ID used to identify the field throughout the theme  
				esc_html__('Video/Thumbnail Height(Shop Page)', 'addify_videos'),                           // The label to the left of the option interface element
				array($this, 'afpv_featured_video_height_shop_page_callback'),   // The name of the function responsible for rendering the option interface
				'addify-product-videos-1',                          // The page on which this option will be displayed  
				'page_1_section',         // The name of the section to which this field belongs  
				array(                              // The array of arguments to pass to the callback. In this case, just a description.  
					esc_html__('Height of the featured video or video thumbnail on shop page.', 'addify_videos'),
				)  
			);  
			register_setting(  
				'setting-group-1',  
				'pv_featured_video_height_shop_page'  
			);

			add_settings_field(   
				'pv_featured_video_width_product_page',                      // ID used to identify the field throughout the theme  
				esc_html__('Video/Thumbnail Width(Product Page)', 'addify_videos'),                           // The label to the left of the option interface element
				array($this, 'afpv_featured_video_width_product_page_callback'),   // The name of the function responsible for rendering the option interface
				'addify-product-videos-1',                          // The page on which this option will be displayed  
				'page_1_section',         // The name of the section to which this field belongs  
				array(                              // The array of arguments to pass to the callback. In this case, just a description.  
					esc_html__('Width of the featured video or video thumbnail on product page.', 'addify_videos'),
				)  
			);  
			register_setting(  
				'setting-group-1',  
				'pv_featured_video_width_product_page'  
			);

			add_settings_field(   
				'pv_featured_video_height_product_page',                      // ID used to identify the field throughout the theme  
				esc_html__('Video/Thumbnail Height(Product Page)', 'addify_videos'),                           // The label to the left of the option interface element
				array($this, 'afpv_featured_video_height_product_page_callback'),   // The name of the function responsible for rendering the option interface
				'addify-product-videos-1',                          // The page on which this option will be displayed  
				'page_1_section',         // The name of the section to which this field belongs  
				array(                              // The array of arguments to pass to the callback. In this case, just a description.  
					esc_html__('Height of the featured video or video thumbnail on product page.', 'addify_videos'),
				)  
			);  
			register_setting(  
				'setting-group-1',  
				'pv_featured_video_height_product_page'  
			);
			

			//Tab 2
			add_settings_section(  
				'page_1_section',         // ID used to identify this section and with which to register options  
				'',   // Title to be displayed on the administration page  
				array($this, 'afpv_page_2_section_callback'), // Callback used to render the description of the section  
				'addify-product-videos-2'                           // Page on which to add this section of options  
			);

			add_settings_field(   
				'pv_featured_enable_tp_auto_play',                      // ID used to identify the field throughout the theme  
				esc_html__('Auto Play Video', 'addify_videos'),                           // The label to the left of the option interface element
				array($this, 'afpv_featured_enable_tp_auto_play_callback'),   // The name of the function responsible for rendering the option interface
				'addify-product-videos-2',                          // The page on which this option will be displayed  
				'page_1_section',         // The name of the section to which this field belongs  
				array(                              // The array of arguments to pass to the callback. In this case, just a description.  
					esc_html__('Allow or Disallow auto play of featured video. Some browsers might block this (https://developers.google.com/web/updates/2017/09/autoplay-policy-changes)', 'addify_videos'),
				)  
			);  
			register_setting(  
				'setting-group-2',  
				'pv_featured_enable_tp_auto_play'  
			);

			add_settings_field(   
				'pv_featured_enable_tp_allow_full',                      // ID used to identify the field throughout the theme  
				esc_html__('Allow Full Screen', 'addify_videos'),                           // The label to the left of the option interface element
				array($this, 'afpv_featured_enable_tp_allow_full_callback'),   // The name of the function responsible for rendering the option interface
				'addify-product-videos-2',                          // The page on which this option will be displayed  
				'page_1_section',         // The name of the section to which this field belongs  
				array(                              // The array of arguments to pass to the callback. In this case, just a description.  
					esc_html__('Allow or Disallow full screen paly of featured video. (Subject to applicability)', 'addify_videos'),
				)  
			);  
			register_setting(  
				'setting-group-2',  
				'pv_featured_enable_tp_allow_full'  
			);

			add_settings_field(   
				'pv_featured_enable_tp_is_mute',                      // ID used to identify the field throughout the theme  
				esc_html__('Mute Video', 'addify_videos'),                           // The label to the left of the option interface element
				array($this, 'afpv_featured_enable_tp_is_mute_callback'),   // The name of the function responsible for rendering the option interface
				'addify-product-videos-2',                          // The page on which this option will be displayed  
				'page_1_section',         // The name of the section to which this field belongs  
				array(                              // The array of arguments to pass to the callback. In this case, just a description.  
					esc_html__('If this option is set to yes, video is muted by defualt. (Subject to applicability)', 'addify_videos'),
				)  
			);  
			register_setting(  
				'setting-group-2',  
				'pv_featured_enable_tp_is_mute'  
			);

			add_settings_field(   
				'pv_featured_enable_tp_show_related',                      // ID used to identify the field throughout the theme  
				esc_html__('Show Related Videos', 'addify_videos'),                           // The label to the left of the option interface element
				array($this, 'afpv_featured_enable_tp_show_related_callback'),   // The name of the function responsible for rendering the option interface
				'addify-product-videos-2',                          // The page on which this option will be displayed  
				'page_1_section',         // The name of the section to which this field belongs  
				array(                              // The array of arguments to pass to the callback. In this case, just a description.  
					esc_html__('Show related videos. (Subject to applicability)', 'addify_videos'),
				)  
			);  
			register_setting(  
				'setting-group-2',  
				'pv_featured_enable_tp_show_related'  
			);
			add_settings_field(   
				'pv_featured_tp_video_width_shop_page',                      // ID used to identify the field throughout the theme  
				esc_html__('Video/Thumbnail Width(Shop Page)', 'addify_videos'),                           // The label to the left of the option interface element
				array($this, 'afpv_featured_tp_video_width_shop_page_callback'),   // The name of the function responsible for rendering the option interface
				'addify-product-videos-2',                          // The page on which this option will be displayed  
				'page_1_section',         // The name of the section to which this field belongs  
				array(                              // The array of arguments to pass to the callback. In this case, just a description.  
					esc_html__('Widht of the featured video or video thumbnail on shop page.', 'addify_videos'),
				)  
			);  
			register_setting(  
				'setting-group-2',  
				'pv_featured_tp_video_width_shop_page'  
			);

			add_settings_field(   
				'pv_featured_tp_video_height_shop_page',                      // ID used to identify the field throughout the theme  
				esc_html__('Video/Thumbnail Height(Shop Page)', 'addify_videos'),                           // The label to the left of the option interface element
				array($this, 'afpv_featured_tp_video_height_shop_page_callback'),   // The name of the function responsible for rendering the option interface
				'addify-product-videos-2',                          // The page on which this option will be displayed  
				'page_1_section',         // The name of the section to which this field belongs  
				array(                              // The array of arguments to pass to the callback. In this case, just a description.  
					esc_html__('Height of the featured video or video thumbnail on shop page.', 'addify_videos'),
				)  
			);  
			register_setting(  
				'setting-group-2',  
				'pv_featured_tp_video_height_shop_page'  
			);

			add_settings_field(   
				'pv_featured_tp_video_width_product_page',                      // ID used to identify the field throughout the theme  
				esc_html__('Video/Thumbnail Width(Product Page)', 'addify_videos'),                           // The label to the left of the option interface element
				array($this, 'afpv_featured_tp_video_width_product_page_callback'),   // The name of the function responsible for rendering the option interface
				'addify-product-videos-2',                          // The page on which this option will be displayed  
				'page_1_section',         // The name of the section to which this field belongs  
				array(                              // The array of arguments to pass to the callback. In this case, just a description.  
					esc_html__('Widht of the featured video or video thumbnail on product page.', 'addify_videos'),
				)  
			);  
			register_setting(  
				'setting-group-2',  
				'pv_featured_tp_video_width_product_page'  
			);

			add_settings_field(   
				'pv_featured_tp_video_height_product_page',                      // ID used to identify the field throughout the theme  
				esc_html__('Video/Thumbnail Height(Product Page)', 'addify_videos'),                           // The label to the left of the option interface element
				array($this, 'afpv_featured_tp_video_height_product_page_callback'),   // The name of the function responsible for rendering the option interface
				'addify-product-videos-2',                          // The page on which this option will be displayed  
				'page_1_section',         // The name of the section to which this field belongs  
				array(                              // The array of arguments to pass to the callback. In this case, just a description.  
					esc_html__('Height of the featured video or video thumbnail on product page.', 'addify_videos'),
				)  
			);  
			register_setting(  
				'setting-group-2',  
				'pv_featured_tp_video_height_product_page'  
			);


			
			//Tab 4

			add_settings_section(  
				'page_1_section',         // ID used to identify this section and with which to register options  
				'',   // Title to be displayed on the administration page  
				array($this, 'afpv_page_4_section_callback'), // Callback used to render the description of the section  
				'addify-product-videos-4'                           // Page on which to add this section of options  
			);

			add_settings_field(   
				'pv_gallery_enable_tp_auto_play',                      // ID used to identify the field throughout the theme  
				esc_html__('Auto Play Video', 'addify_videos'),                           // The label to the left of the option interface element
				array($this, 'afpv_gallery_enable_tp_auto_play_callback'),   // The name of the function responsible for rendering the option interface
				'addify-product-videos-4',                          // The page on which this option will be displayed  
				'page_1_section',         // The name of the section to which this field belongs  
				array(                              // The array of arguments to pass to the callback. In this case, just a description.  
					esc_html__('Allow or Disallow auto play of gallery video when open in popup. Some browsers might block this (https://developers.google.com/web/updates/2017/09/autoplay-policy-changes)', 'addify_videos'),
				)  
			);  
			register_setting(  
				'setting-group-4',  
				'pv_gallery_enable_tp_auto_play'  
			);

			add_settings_field(   
				'pv_gallery_enable_tp_allow_full',                      // ID used to identify the field throughout the theme  
				esc_html__('Allow Full Screen', 'addify_videos'),                           // The label to the left of the option interface element
				array($this, 'afpv_gallery_enable_tp_allow_full_callback'),   // The name of the function responsible for rendering the option interface
				'addify-product-videos-4',                          // The page on which this option will be displayed  
				'page_1_section',         // The name of the section to which this field belongs  
				array(                              // The array of arguments to pass to the callback. In this case, just a description.  
					esc_html__('Allow or Disallow full screen paly of gallery video when open in poup. (Subject to applicability)', 'addify_videos'),
				)  
			);  
			register_setting(  
				'setting-group-4',  
				'pv_gallery_enable_tp_allow_full'  
			);

			add_settings_field(   
				'pv_gallery_enable_tp_is_mute',                      // ID used to identify the field throughout the theme  
				esc_html__('Mute Video', 'addify_videos'),                           // The label to the left of the option interface element
				array($this, 'afpv_gallery_enable_tp_is_mute_callback'),   // The name of the function responsible for rendering the option interface
				'addify-product-videos-4',                          // The page on which this option will be displayed  
				'page_1_section',         // The name of the section to which this field belongs  
				array(                              // The array of arguments to pass to the callback. In this case, just a description.  
					esc_html__('Mute gallery video when open in popup. (Subject to applicability)', 'addify_videos'),
				)  
			);  
			register_setting(  
				'setting-group-4',  
				'pv_gallery_enable_tp_is_mute'  
			);

			add_settings_field(   
				'pv_gallery_enable_tp_show_related',                      // ID used to identify the field throughout the theme  
				esc_html__('Show Related Videos', 'addify_videos'),                           // The label to the left of the option interface element
				array($this, 'afpv_gallery_enable_tp_show_related_callback'),   // The name of the function responsible for rendering the option interface
				'addify-product-videos-4',                          // The page on which this option will be displayed  
				'page_1_section',         // The name of the section to which this field belongs  
				array(                              // The array of arguments to pass to the callback. In this case, just a description.  
					esc_html__('Show related videos. (Subject to applicability)', 'addify_videos'),
				)  
			);  
			register_setting(  
				'setting-group-4',  
				'pv_gallery_enable_tp_show_related'  
			);

			//Tab 5
			add_settings_section(  
				'page_1_section',         // ID used to identify this section and with which to register options  
				'',   // Title to be displayed on the administration page  
				array($this, 'afpv_page_5_section_callback'), // Callback used to render the description of the section  
				'addify-product-videos-5'                           // Page on which to add this section of options  
			);

			add_settings_field(   
				'pv_product_page_edited',                      // ID used to identify the field throughout the theme  
				esc_html__('Page Edited by Elementor or Divi Builder', 'addify_videos'),                           // The label to the left of the option interface element
				array($this, 'pv_product_page_edited_callback'),   // The name of the function responsible for rendering the option interface
				'addify-product-videos-5',                          // The page on which this option will be displayed  
				'page_1_section',         // The name of the section to which this field belongs  
				array(                              // The array of arguments to pass to the callback. In this case, just a description.  
					esc_html__('Select yes if your Product page is Edited with Elementor or Divi Builder', 'addify_videos'),
				)  
			);  
			register_setting(  
				'setting-group-5',  
				'pv_product_page_edited'  
			);

		}

		public function afpv_page_1_section_callback() {
			?>

		   <h2><?php echo esc_html__('Self Hosted Product Featured Video Settings', 'addify_videos'); ?></h2>
		   
			<?php
		} // function afpv_page_1_section_callback

		public function afpv_featured_enable_auto_play_callback( $args ) {  
			?>
		   
			<select id="pv_featured_enable_auto_play" class="login_title" name="pv_featured_enable_auto_play">
				<option value="1" <?php echo selected('1', get_option('pv_featured_enable_auto_play')); ?>><?php echo esc_html__('Yes', 'addify_videos'); ?></option>
				<option value="0" <?php echo selected('0', get_option('pv_featured_enable_auto_play')); ?>><?php echo esc_html__('No', 'addify_videos'); ?></option>
			</select>
			<p class="description pv_featured_enable_auto_play"> <?php echo esc_attr($args[0]); ?> </p>
			
			<?php      
		} // end pv_featured_enable_auto_play_callback 

		public function afpv_featured_enable_is_loop_callback( $args ) {  
			?>
		   
			<select id="pv_featured_enable_is_loop" class="login_title" name="pv_featured_enable_is_loop">
				<option value="1" <?php echo selected('1', get_option('pv_featured_enable_is_loop')); ?>><?php echo esc_html__('Yes', 'addify_videos'); ?></option>
				<option value="0" <?php echo selected('0', get_option('pv_featured_enable_is_loop')); ?>><?php echo esc_html__('No', 'addify_videos'); ?></option>
			</select>
			<p class="description pv_featured_enable_is_loop"> <?php echo esc_attr($args[0]); ?> </p>
			
			<?php      
		} // end pv_featured_enable_is_loop_callback 

		public function afpv_featured_enable_is_mute_callback( $args ) {  
			?>
			
			<select id="pv_featured_enable_is_mute" class="login_title" name="pv_featured_enable_is_mute">
				<option value="1" <?php echo selected('1', get_option('pv_featured_enable_is_mute')); ?>><?php echo esc_html__('Yes', 'addify_videos'); ?></option>
				<option value="0" <?php echo selected('0', get_option('pv_featured_enable_is_mute')); ?>><?php echo esc_html__('No', 'addify_videos'); ?></option>
			</select>
			<p class="description pv_featured_enable_is_mute"> <?php echo esc_attr($args[0]); ?> </p>
		   
			<?php      
		} // end pv_featured_enable_is_mute_callback 

		public function afpv_featured_enable_video_controls_callback( $args ) {  
			?>
			
			<select id="pv_featured_enable_video_controls" class="login_title" name="pv_featured_enable_video_controls">
				<option value="1" <?php echo selected('1', get_option('pv_featured_enable_video_controls')); ?>><?php echo esc_html__('Yes', 'addify_videos'); ?></option>
				<option value="0" <?php echo selected('0', get_option('pv_featured_enable_video_controls')); ?>><?php echo esc_html__('No', 'addify_videos'); ?></option>
			</select>
			<p class="description pv_featured_enable_video_controls"> <?php echo esc_attr($args[0]); ?> </p>
		   
			<?php      
		} // end pv_featured_enable_video_controls_callback 

		public function afpv_featured_video_width_shop_page_callback( $args ) {  
			?>
			
			<input type="number" min="0" name="pv_featured_video_width_shop_page" id="pv_featured_video_width_shop_page" class="login_title" value="<?php echo esc_attr(get_option('pv_featured_video_width_shop_page')); ?>" /> %
			<p class="description pv_featured_video_width_shop_page"> <?php echo esc_attr($args[0]); ?> </p>
		   
			<?php      
		} // end pv_featured_video_width_shop_page_callback 


		public function afpv_featured_video_height_shop_page_callback( $args ) {  
			?>
			
			<input type="number" min="0" name="pv_featured_video_height_shop_page" id="pv_featured_video_height_shop_page" class="login_title" value="<?php echo esc_attr(get_option('pv_featured_video_height_shop_page')); ?>" /> px
			<p class="description pv_featured_video_height_shop_page"> <?php echo esc_attr($args[0]); ?> </p>
		   
			<?php      
		} // end pv_featured_video_height_shop_page_callback 

		public function afpv_featured_video_width_product_page_callback( $args ) {  
			?>
			
			<input type="number" min="0" name="pv_featured_video_width_product_page" id="pv_featured_video_width_product_page" class="login_title" value="<?php echo esc_attr(get_option('pv_featured_video_width_product_page')); ?>" /> %
			<p class="description pv_featured_video_width_product_page"> <?php echo esc_attr($args[0]); ?> </p>
		   
			<?php      
		} // end pv_featured_video_width_product_page_callback 


		public function afpv_featured_video_height_product_page_callback( $args ) {  
			?>
			
			<input type="number" min="0" name="pv_featured_video_height_product_page" id="pv_featured_video_height_product_page" class="login_title" value="<?php echo esc_attr(get_option('pv_featured_video_height_product_page')); ?>" /> px
			<p class="description pv_featured_video_height_product_page"> <?php echo esc_attr($args[0]); ?> </p>
		   
			<?php      
		} // end pv_featured_video_height_product_page_callback 

		//Tab 2 Callbacks

		public function afpv_page_2_section_callback() {
			?>

		   <h2><?php echo esc_html__('Third Party Product Featured Video Settings', 'addify_videos'); ?></h2>

			<?php
		}// function afpv_page_2_section_callback

		public function afpv_featured_enable_tp_auto_play_callback( $args ) {  
			?>
		   
			<select id="pv_featured_enable_tp_auto_play" class="login_title" name="pv_featured_enable_tp_auto_play">
				<option value="1" <?php echo selected('1', get_option('pv_featured_enable_tp_auto_play')); ?>><?php echo esc_html__('Yes', 'addify_videos'); ?></option>
				<option value="0" <?php echo selected('0', get_option('pv_featured_enable_tp_auto_play')); ?>><?php echo esc_html__('No', 'addify_videos'); ?></option>
			</select>
			<p class="description pv_featured_enable_tp_auto_play"> <?php echo esc_attr($args[0]); ?> </p>
			
			<?php      
		} // end pv_featured_enable_tp_auto_play_callback 


		public function afpv_featured_enable_tp_allow_full_callback( $args ) {  
			?>
		   
			<select id="pv_featured_enable_tp_allow_full" class="login_title" name="pv_featured_enable_tp_allow_full">
				<option value="1" <?php echo selected('1', get_option('pv_featured_enable_tp_allow_full')); ?>><?php echo esc_html__('Yes', 'addify_videos'); ?></option>
				<option value="0" <?php echo selected('0', get_option('pv_featured_enable_tp_allow_full')); ?>><?php echo esc_html__('No', 'addify_videos'); ?></option>
			</select>
			<p class="description pv_featured_enable_tp_allow_full"> <?php echo esc_attr($args[0]); ?> </p>
			
			<?php      
		} // end pv_featured_enable_tp_allow_full_callback 

		public function afpv_featured_enable_tp_is_mute_callback( $args ) {  
			?>
		   
			<select id="pv_featured_enable_tp_is_mute" class="login_title" name="pv_featured_enable_tp_is_mute">
				<option value="1" <?php echo selected('1', get_option('pv_featured_enable_tp_is_mute')); ?>><?php echo esc_html__('Yes', 'addify_videos'); ?></option>
				<option value="0" <?php echo selected('0', get_option('pv_featured_enable_tp_is_mute')); ?>><?php echo esc_html__('No', 'addify_videos'); ?></option>
			</select>
			<p class="description pv_featured_enable_tp_is_mute"> <?php echo esc_attr($args[0]); ?> </p>
			
			<?php      
		} // end pv_featured_enable_tp_is_mute_callback 

		public function afpv_featured_enable_tp_show_related_callback( $args ) {  
			?>
		   
			<select id="pv_featured_enable_tp_show_related" class="login_title" name="pv_featured_enable_tp_show_related">
				<option value="1" <?php echo selected('1', get_option('pv_featured_enable_tp_show_related')); ?>><?php echo esc_html__('Yes', 'addify_videos'); ?></option>
				<option value="0" <?php echo selected('0', get_option('pv_featured_enable_tp_show_related')); ?>><?php echo esc_html__('No', 'addify_videos'); ?></option>
			</select>
			<p class="description pv_featured_enable_tp_show_related"> <?php echo esc_attr($args[0]); ?> </p>
			
			<?php      
		} // end pv_featured_enable_tp_show_related_callback 

		public function afpv_featured_tp_video_width_shop_page_callback( $args ) {  
			?>
			
			<input type="number" min="0" name="pv_featured_tp_video_width_shop_page" id="pv_featured_tp_video_width_shop_page" class="login_title" value="<?php echo esc_attr(get_option('pv_featured_tp_video_width_shop_page')); ?>" /> %
			<p class="description pv_featured_tp_video_width_shop_page"> <?php echo esc_attr($args[0]); ?> </p>
		   
			<?php      
		} // end pv_featured_tp_video_width_shop_page_callback 

		public function afpv_featured_tp_video_height_shop_page_callback( $args ) {  
			?>
			
			<input type="number" min="0" name="pv_featured_tp_video_height_shop_page" id="pv_featured_tp_video_height_shop_page" class="login_title" value="<?php echo esc_attr(get_option('pv_featured_tp_video_height_shop_page')); ?>" /> px
			<p class="description pv_featured_tp_video_height_shop_page"> <?php echo esc_attr($args[0]); ?> </p>
		   
			<?php      
		} // end pv_featured_tp_video_height_shop_page_callback 

		public function afpv_featured_tp_video_width_product_page_callback( $args ) {  
			?>
			
			<input type="number" min="0" name="pv_featured_tp_video_width_product_page" id="pv_featured_tp_video_width_product_page" class="login_title" value="<?php echo esc_attr(get_option('pv_featured_tp_video_width_product_page')); ?>" /> %
			<p class="description pv_featured_tp_video_width_product_page"> <?php echo esc_attr($args[0]); ?> </p>
		   
			<?php      
		} // end pv_featured_tp_video_width_product_page_callback 

		public function afpv_featured_tp_video_height_product_page_callback( $args ) {  
			?>
			
			<input type="number" min="0" name="pv_featured_tp_video_height_product_page" id="pv_featured_tp_video_height_product_page" class="login_title" value="<?php echo esc_attr(get_option('pv_featured_tp_video_height_product_page')); ?>" /> px
			<p class="description pv_featured_tp_video_height_product_page"> <?php echo esc_attr($args[0]); ?> </p>
		   
			<?php      
		} // end pv_featured_tp_video_height_product_page_callback 

		
		
		//Tab 4 callbacks

		public function afpv_page_4_section_callback() {
			?>

		   <h2><?php echo esc_html__('Third Party Product Gallery Video Settings', 'addify_videos'); ?></h2>

			<?php
		} // function afpv_page_4_section_callback

		public function afpv_gallery_enable_tp_auto_play_callback( $args ) {  
			?>
		   
			<select id="pv_gallery_enable_tp_auto_play" class="login_title" name="pv_gallery_enable_tp_auto_play">
				<option value="1" <?php echo selected('1', get_option('pv_gallery_enable_tp_auto_play')); ?>><?php echo esc_html__('Yes', 'addify_videos'); ?></option>
				<option value="0" <?php echo selected('0', get_option('pv_gallery_enable_tp_auto_play')); ?>><?php echo esc_html__('No', 'addify_videos'); ?></option>
			</select>
			<p class="description pv_gallery_enable_tp_auto_play"> <?php echo esc_attr($args[0]); ?> </p>
			
			<?php      
		} // end afpv_gallery_enable_tp_auto_play_callback 


		public function afpv_gallery_enable_tp_allow_full_callback( $args ) {  
			?>
		   
			<select id="pv_gallery_enable_tp_allow_full" class="login_title" name="pv_gallery_enable_tp_allow_full">
				<option value="1" <?php echo selected('1', get_option('pv_gallery_enable_tp_allow_full')); ?>><?php echo esc_html__('Yes', 'addify_videos'); ?></option>
				<option value="0" <?php echo selected('0', get_option('pv_gallery_enable_tp_allow_full')); ?>><?php echo esc_html__('No', 'addify_videos'); ?></option>
			</select>
			<p class="description pv_gallery_enable_tp_allow_full"> <?php echo esc_attr($args[0]); ?> </p>
			
			<?php      
		} // end afpv_gallery_enable_tp_allow_full_callback 

		public function afpv_gallery_enable_tp_is_mute_callback( $args ) {  
			?>
		   
			<select id="pv_gallery_enable_tp_is_mute" class="login_title" name="pv_gallery_enable_tp_is_mute">
				<option value="1" <?php echo selected('1', get_option('pv_gallery_enable_tp_is_mute')); ?>><?php echo esc_html__('Yes', 'addify_videos'); ?></option>
				<option value="0" <?php echo selected('0', get_option('pv_gallery_enable_tp_is_mute')); ?>><?php echo esc_html__('No', 'addify_videos'); ?></option>
			</select>
			<p class="description pv_gallery_enable_tp_is_mute"> <?php echo esc_attr($args[0]); ?> </p>
			
			<?php      
		} // end afpv_gallery_enable_tp_is_mute_callback 

		public function afpv_gallery_enable_tp_show_related_callback( $args ) {  
			?>
		   
			<select id="pv_gallery_enable_tp_show_related" class="login_title" name="pv_gallery_enable_tp_show_related">
				<option value="1" <?php echo selected('1', get_option('pv_gallery_enable_tp_show_related')); ?>><?php echo esc_html__('Yes', 'addify_videos'); ?></option>
				<option value="0" <?php echo selected('0', get_option('pv_gallery_enable_tp_show_related')); ?>><?php echo esc_html__('No', 'addify_videos'); ?></option>
			</select>
			<p class="description pv_gallery_enable_tp_show_related"> <?php echo esc_attr($args[0]); ?> </p>
			
			<?php      
		} // end afpv_gallery_enable_tp_show_related_callback 

		public function afpv_page_5_section_callback() {
			?>

		   <h2><?php echo esc_html__('Elemntor/Divi Builder Edited Page', 'addify_videos'); ?></h2>

			<?php
		} // function afpv_page_4_section_callback


		public function pv_product_page_edited_callback( $args ) {  
			?>
		   
			<select id="pv_product_page_edited" class="login_title" name="pv_product_page_edited">
				
				<option value="0" <?php echo selected('0', get_option('pv_product_page_edited')); ?>><?php echo esc_html__('No', 'addify_videos'); ?></option>
				<option value="1" <?php echo selected('1', get_option('pv_product_page_edited')); ?>><?php echo esc_html__('Yes', 'addify_videos'); ?></option>
			</select>
			<p class="description pv_gallery_enable_tp_show_related"> <?php echo esc_attr($args[0]); ?> </p>
			
			<?php      
		} // end afpv_gallery_enable_tp_show_related_callback 


		public function afpv_vidoes_metaboxes() {

			add_meta_box( 'afpv_featured_video', esc_html__( 'Featured Video', 'addify_videos' ), array( $this, 'afpv_featured_video_callback' ), 'product', 'normal', 'high' );

			add_meta_box( 'afpv_product_video', esc_html__( 'Video', 'addify_videos' ), array( $this, 'afpv_product_video_callback' ), 'af_product_videos', 'normal', 'high' );
			
		}

		public function afpv_featured_video_callback() { 

			global $post;
			wp_nonce_field('afpv_nonce_action', 'afpv_nonce_field');
			$afpv_enable_featured_video              = get_post_meta( intval($post->ID), 'afpv_enable_featured_video', true );
			$afpv_enable_featured_video_shop_page    = get_post_meta( intval($post->ID), 'afpv_enable_featured_video_shop_page', true );
			$afpv_enable_featured_video_product_page = get_post_meta( intval($post->ID), 'afpv_enable_featured_video_product_page', true );
			$afpv_featured_video_type                = get_post_meta( intval($post->ID), 'afpv_featured_video_type', true );
			$afpv_yt_featured_video_id               = get_post_meta( intval($post->ID), 'afpv_yt_featured_video_id', true );
			$afpv_fb_featured_video_id               = get_post_meta( intval($post->ID), 'afpv_fb_featured_video_id', true );
			$afpv_dm_featured_video_id               = get_post_meta( intval($post->ID), 'afpv_dm_featured_video_id', true );
			$afpv_vm_featured_video_id               = get_post_meta( intval($post->ID), 'afpv_vm_featured_video_id', true );
			$afpv_mc_featured_video_id               = get_post_meta( intval($post->ID), 'afpv_mc_featured_video_id', true );
			$afpv_cus_featured_video_id              = get_post_meta( intval($post->ID), 'afpv_cus_featured_video_id', true );
			$afpv_video_thumb                        = get_post_meta( intval($post->ID), 'afpv_video_thumb', true );

			?>

			<div class="meta_field_full">
				
				<label for="afpv_enable_featured_video"><?php echo esc_html__('Enable Featured Video', 'addify_videos'); ?></label>
				<select name="afpv_enable_featured_video" id="afpv_enable_featured_video" class="afpv_field_select">
					<option value="1" <?php echo selected(esc_attr($afpv_enable_featured_video), '1'); ?>><?php echo esc_html__('Yes', 'addify_videos'); ?></option>
					<option value="0" <?php echo selected(esc_attr($afpv_enable_featured_video), '0'); ?>><?php echo esc_html__('No', 'addify_videos'); ?></option>
				</select>
				<p><?php echo esc_html__('If featured video is enabled then featured image will be replaced with featured video.', 'addify_videos'); ?></p>
			</div>

			<div class="meta_field_full">
				
				<label for="afpv_enable_featured_video_shop_page"><?php echo esc_html__('Enable Featured Video On Shop Page', 'addify_videos'); ?></label>
				<p>
				<input type="checkbox" name="afpv_enable_featured_video_shop_page" value="yes" <?php echo checked(esc_attr($afpv_enable_featured_video_shop_page), 'yes'); ?> >
				<?php echo esc_html__('Check this option if you want to enable featured video on shop page, this will replace featured image with featured video.', 'addify_videos'); ?></p>
			</div>

			<div class="meta_field_full">
				
				<label for="afpv_enable_featured_video_product_page"><?php echo esc_html__('Enable Featured Video On Product Page', 'addify_videos'); ?></label>
				<p>
				<input type="checkbox" name="afpv_enable_featured_video_product_page" value="yes" <?php echo checked(esc_attr($afpv_enable_featured_video_product_page), 'yes'); ?> >
				<?php echo esc_html__('Check this option if you want to enable featured video on Product page, this will replace featured image with featured video.', 'addify_videos'); ?></p>
			</div>

			<div class="meta_field_full">
				
				<div class="imgdis" id="logodisplay">
					<?php if (!empty($afpv_video_thumb)) { ?>
					<label for="afpv_video_thumb"><?php echo esc_html__('Current Video Thumbnail', 'addify_videos'); ?></label>
					<img src="<?php echo esc_url($afpv_video_thumb); ?>" width="200" />
					<?php } ?>
				
				</div>

				<label for="afpv_video_thumb"><?php echo esc_html__('Video Thumbnail', 'addify_videos'); ?></label>
				<input type="hidden" value="<?php echo esc_url($afpv_video_thumb); ?>" name="afpv_video_thumb" id="afpv_thumb_url" class="login_title">
				<input onClick="afpv_image()" type="button" name="upload-btn" id="upload-image-btn" class="button-secondary" value="<?php echo esc_html__('Upload Image', 'addify_videos'); ?>">
				<input onClick="afpv_clear_image()" type="button" name="upload-btn" id="clear-image-btn" class="button-secondary" value="<?php echo esc_html__('Remove Image', 'addify_videos'); ?>">
				<p><?php echo esc_html__('If thumbnail is added for the video then video is played in popup when click on this thumbnail.', 'addify_videos'); ?></p>
				
			</div>


			<div class="meta_field_full">
				<label for="afpv_featured_video_type"><?php echo esc_html__('Featured Video Type', 'addify_videos'); ?></label>
				<select name="afpv_featured_video_type" id="afpv_featured_video_type" class="afpv_field_select" onchange="getVideoType(this.value)">
					<option value="youtube" <?php echo selected(esc_attr($afpv_featured_video_type), 'youtube'); ?>><?php echo esc_html__('YouTube', 'addify_videos'); ?></option>
					<option value="facebook" <?php echo selected(esc_attr($afpv_featured_video_type), 'facebook'); ?>><?php echo esc_html__('Facebook', 'addify_videos'); ?></option>
					<option value="dailymotion" <?php echo selected(esc_attr($afpv_featured_video_type), 'dailymotion'); ?>><?php echo esc_html__('Dailymotion', 'addify_videos'); ?></option>
					<option value="vimeo" <?php echo selected(esc_attr($afpv_featured_video_type), 'vimeo'); ?>><?php echo esc_html__('Vimeo', 'addify_videos'); ?></option>
					<option value="metacafe" <?php echo selected(esc_attr($afpv_featured_video_type), 'metacafe'); ?>><?php echo esc_html__('Metacafe', 'addify_videos'); ?></option>
					<option value="custom" <?php echo selected(esc_attr($afpv_featured_video_type), 'custom'); ?>><?php echo esc_html__('Custom Upload', 'addify_videos'); ?></option>
					
				</select>
			</div>

			<div class="meta_field_full" id="youtube">
				<label for="afpv_yt_featured_video_id"><?php echo esc_html__('YouTube Video ID', 'addify_videos'); ?></label>
				<input type="text" name="afpv_yt_featured_video_id" id="afpv_yt_featured_video_id" class="afpv_field_text" value="<?php echo esc_attr($afpv_yt_featured_video_id); ?>" />
				<p><?php echo esc_html__('Add your YouTube video ID like (6lt2JfJdGSY). Do not put complete video URL only enter video ID that come after this URL (https://www.youtube.com/watch?v=)', 'addify_videos'); ?></p>
			</div>

			<div class="meta_field_full" id="facebook">
				<label for="afpv_fb_featured_video_id"><?php echo esc_html__('Facebook Video URL', 'addify_videos'); ?></label>
				<input type="text" name="afpv_fb_featured_video_id" id="afpv_fb_featured_video_id" class="afpv_field_text" value="<?php echo esc_attr($afpv_fb_featured_video_id); ?>" />
				<p><?php echo esc_html__('Add facebook video link here, e.g (https://www.facebook.com/facebook/videos/XXXXXXXXXXXXX)', 'addify_videos'); ?></p>
			</div>

			<div class="meta_field_full" id="dailymotion">
				<label for="afpv_dm_featured_video_id"><?php echo esc_html__('Dailymotion Video ID', 'addify_videos'); ?></label>
				<input type="text" name="afpv_dm_featured_video_id" id="afpv_dm_featured_video_id" class="afpv_field_text" value="<?php echo esc_attr($afpv_dm_featured_video_id); ?>" />
				<p><?php echo esc_html__('Add dailymotion video id here e.g (x5z1gzv). Do not put complete video URL only enter video ID that come after this URL (https://www.dailymotion.com/embed/video/)', 'addify_videos'); ?></p>
			</div>

			<div class="meta_field_full" id="vimeo">
				<label for="afpv_vm_featured_video_id"><?php echo esc_html__('Vimeo Video ID', 'addify_videos'); ?></label>
				<input type="text" name="afpv_vm_featured_video_id" id="afpv_vm_featured_video_id" class="afpv_field_text" value="<?php echo esc_attr($afpv_vm_featured_video_id); ?>" />
				<p><?php echo esc_html__('Add vimeo video id here e.g (217936008). Do not put complete video URL only enter video ID that come after this URL (https://vimeo.com/)', 'addify_videos'); ?></p>
			</div>

			<div class="meta_field_full" id="metacafe">
				<label for="afpv_mc_featured_video_id"><?php echo esc_html__('Metacafe Video ID', 'addify_videos'); ?></label>
				<input type="text" name="afpv_mc_featured_video_id" id="afpv_mc_featured_video_id" class="afpv_field_text" value="<?php echo esc_attr($afpv_mc_featured_video_id); ?>" />
				<p><?php echo esc_html__('Add metacafe video id here e.g (11858937/top-benefits-of-woocommerce/). Do not put complete video URL only enter video ID that come after this URL (http://www.metacafe.com/watch/)', 'addify_videos'); ?></p>
			</div>

			<div class="meta_field_full" id="custom">
				
				<div class="imgdis" id="afpv-videp-id">
					<?php if (!empty($afpv_cus_featured_video_id)) { ?>
					<label for="afpv_cus_featured_video_id"><?php echo esc_html__('Current Video', 'addify_videos'); ?></label>
					<video  frameborder="0" controls width="500">
						<source src="<?php echo esc_url($afpv_cus_featured_video_id); ?>" type="video/mp4">
					</video>
					<?php } ?>
				</div>

				<label for="afpv_cus_featured_video_id"><?php echo esc_html__('Custom Video', 'addify_videos'); ?></label>
				<input type="hidden" value="<?php echo esc_url($afpv_cus_featured_video_id); ?>" name="afpv_cus_featured_video_id" id="afpv_video_url" class="login_title">
				<input onClick="afpv_video()"   type="button" name="upload-btn" id="upload-video-btn" class="button-secondary" value="<?php echo esc_html__('Upload Video', 'addify_videos'); ?>">
				
			</div>

			<?php
		}

		public function afpv_meta_box_save( $post_id ) {

			// return if we're doing an auto save
			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {

				return;	
			} 

			if ( get_post_status( $post_id ) === 'auto-draft' ) {
				return;
			}

		   
			if ( isset( $_POST['afpv_enable_featured_video'] ) ) { 

				if (!empty($_REQUEST['afpv_nonce_field'])) {

						$retrieved_nonce = sanitize_text_field($_REQUEST['afpv_nonce_field']);
				} else {
						$retrieved_nonce = 0;
				}

				if (!wp_verify_nonce($retrieved_nonce, 'afpv_nonce_action')) {

					die('Failed security check');
				}
				
				update_post_meta( intval($post_id), 'afpv_enable_featured_video', sanitize_text_field( $_POST['afpv_enable_featured_video'] ) );
			}

			if ( isset( $_POST['afpv_enable_featured_video_shop_page'] ) ) { 
				update_post_meta( intval($post_id), 'afpv_enable_featured_video_shop_page', sanitize_text_field( $_POST['afpv_enable_featured_video_shop_page'] ) );
			} else {

				update_post_meta( intval($post_id), 'afpv_enable_featured_video_shop_page', 'no' );   
			}

			if ( isset( $_POST['afpv_enable_featured_video_product_page'] ) ) { 
				update_post_meta( intval($post_id), 'afpv_enable_featured_video_product_page', sanitize_text_field( $_POST['afpv_enable_featured_video_product_page'] ) );
			} else {

				update_post_meta( intval($post_id), 'afpv_enable_featured_video_product_page', 'no' );   
			}

			if ( isset( $_POST['afpv_video_thumb'] ) ) { 
				update_post_meta( intval($post_id), 'afpv_video_thumb', sanitize_text_field( $_POST['afpv_video_thumb'] ) );
			}

			if ( isset( $_POST['afpv_featured_video_type'] ) ) { 
				update_post_meta( intval($post_id), 'afpv_featured_video_type', sanitize_text_field( $_POST['afpv_featured_video_type'] ) );
			}

			//YouTube
			if ( isset( $_POST['afpv_yt_featured_video_id'] ) ) { 
				update_post_meta( intval($post_id), 'afpv_yt_featured_video_id', sanitize_text_field( $_POST['afpv_yt_featured_video_id'] ) );
			}

			//Faebook
			if ( isset( $_POST['afpv_fb_featured_video_id'] ) ) { 
				update_post_meta( intval($post_id), 'afpv_fb_featured_video_id', sanitize_text_field( $_POST['afpv_fb_featured_video_id'] ) );
			}

			//Dailymotion
			if ( isset( $_POST['afpv_dm_featured_video_id'] ) ) { 
				update_post_meta( intval($post_id), 'afpv_dm_featured_video_id', sanitize_text_field( $_POST['afpv_dm_featured_video_id'] ) );
			}

			//Vimeo
			if ( isset( $_POST['afpv_vm_featured_video_id'] ) ) { 
				update_post_meta( intval($post_id), 'afpv_vm_featured_video_id', sanitize_text_field( $_POST['afpv_vm_featured_video_id'] ) );
			}

			//Metacafe
			if ( isset( $_POST['afpv_mc_featured_video_id'] ) ) { 
				update_post_meta( intval($post_id), 'afpv_mc_featured_video_id', sanitize_text_field( $_POST['afpv_mc_featured_video_id'] ) );
			}

			//Custom
			if ( isset( $_POST['afpv_cus_featured_video_id'] ) ) { 
				update_post_meta( intval($post_id), 'afpv_cus_featured_video_id', sanitize_text_field( $_POST['afpv_cus_featured_video_id'] ) );
			}

			//Product Video Gallery


			if ( isset( $_POST['afpv_product_video_thumb'] ) ) { 
				update_post_meta( intval($post_id), 'afpv_product_video_thumb', sanitize_text_field( $_POST['afpv_product_video_thumb'] ) );
			}

			if ( isset( $_POST['afpv_product_video_type'] ) ) { 
				update_post_meta( intval($post_id), 'afpv_product_video_type', sanitize_text_field( $_POST['afpv_product_video_type'] ) );
			}

			//YouTube
			if ( isset( $_POST['afpv_yt_product_video_id'] ) ) { 
				update_post_meta( intval($post_id), 'afpv_yt_product_video_id', sanitize_text_field( $_POST['afpv_yt_product_video_id'] ) );
			}

			//Faebook
			if ( isset( $_POST['afpv_fb_product_video_id'] ) ) { 
				update_post_meta( intval($post_id), 'afpv_fb_product_video_id', sanitize_text_field( $_POST['afpv_fb_product_video_id'] ) );
			}

			//Dailymotion
			if ( isset( $_POST['afpv_dm_product_video_id'] ) ) { 
				update_post_meta( intval($post_id), 'afpv_dm_product_video_id', sanitize_text_field( $_POST['afpv_dm_product_video_id'] ) );
			}

			//Vimeo
			if ( isset( $_POST['afpv_vm_product_video_id'] ) ) { 
				update_post_meta( intval($post_id), 'afpv_vm_product_video_id', sanitize_text_field( $_POST['afpv_vm_product_video_id'] ) );
			}

			//Metacafe
			if ( isset( $_POST['afpv_mc_product_video_id'] ) ) { 
				update_post_meta( intval($post_id), 'afpv_mc_product_video_id', sanitize_text_field( $_POST['afpv_mc_product_video_id'] ) );
			}

			//Custom
			if ( isset( $_POST['afpv_cus_product_video_id'] ) ) { 
				update_post_meta( intval($post_id), 'afpv_cus_product_video_id', sanitize_text_field( $_POST['afpv_cus_product_video_id'] ) );
			}

			//Applied Products
			if ( isset( $_POST['afpv_applied_products'] ) ) { 
				update_post_meta( intval($post_id), 'afpv_applied_products', serialize(sanitize_meta('afpv_applied_products', $_POST['afpv_applied_products'], '' ) ));
			}

			
		}

		public function afpv_product_video_callback() {

			global $post;
			wp_nonce_field('afpv_nonce_action', 'afpv_nonce_field');
			
			$afpv_product_video_type   = get_post_meta( intval($post->ID), 'afpv_product_video_type', true );
			$afpv_yt_product_video_id  = get_post_meta( intval($post->ID), 'afpv_yt_product_video_id', true );
			$afpv_fb_product_video_id  = get_post_meta( intval($post->ID), 'afpv_fb_product_video_id', true );
			$afpv_dm_product_video_id  = get_post_meta( intval($post->ID), 'afpv_dm_product_video_id', true );
			$afpv_vm_product_video_id  = get_post_meta( intval($post->ID), 'afpv_vm_product_video_id', true );
			$afpv_mc_product_video_id  = get_post_meta( intval($post->ID), 'afpv_mc_product_video_id', true );
			$afpv_cus_product_video_id = get_post_meta( intval($post->ID), 'afpv_cus_product_video_id', true );
			$afpv_product_video_thumb  = get_post_meta( intval($post->ID), 'afpv_product_video_thumb', true );

			$afpv_applied_products = unserialize(get_post_meta( intval($post->ID), 'afpv_applied_products', true ));

			?>

			<div class="meta_field_full">
				<label for="afpv_product_video_type"><?php echo esc_html__('Product Video Type', 'addify_videos'); ?></label>
				<select name="afpv_product_video_type" id="afpv_product_video_type" class="afpv_field_select" onchange="getVideoType(this.value)">
					<option value="youtube" <?php echo selected(esc_attr($afpv_product_video_type), 'youtube'); ?>><?php echo esc_html__('YouTube', 'addify_videos'); ?></option>
					<option value="facebook" <?php echo selected(esc_attr($afpv_product_video_type), 'facebook'); ?>><?php echo esc_html__('Facebook', 'addify_videos'); ?></option>
					<option value="dailymotion" <?php echo selected(esc_attr($afpv_product_video_type), 'dailymotion'); ?>><?php echo esc_html__('Dailymotion', 'addify_videos'); ?></option>
					<option value="vimeo" <?php echo selected(esc_attr($afpv_product_video_type), 'vimeo'); ?>><?php echo esc_html__('Vimeo', 'addify_videos'); ?></option>
					<option value="metacafe" <?php echo selected(esc_attr($afpv_product_video_type), 'metacafe'); ?>><?php echo esc_html__('Metacafe', 'addify_videos'); ?></option>
					<option value="custom" <?php echo selected(esc_attr($afpv_product_video_type), 'custom'); ?>><?php echo esc_html__('Custom Upload', 'addify_videos'); ?></option>
					
				</select>
			</div>

			<div class="meta_field_full" id="youtube">
				<label for="afpv_yt_product_video_id"><?php echo esc_html__('YouTube Video ID', 'addify_videos'); ?></label>
				<input type="text" name="afpv_yt_product_video_id" id="afpv_yt_product_video_id" class="afpv_field_text" value="<?php echo esc_attr($afpv_yt_product_video_id); ?>" />
				<p><?php echo esc_html__('Add your YouTube video ID like (6lt2JfJdGSY). Do not put complete video URL only enter video ID that come after this URL (https://www.youtube.com/watch?v=)', 'addify_videos'); ?></p>
			</div>

			<div class="meta_field_full" id="facebook">
				<label for="afpv_fb_product_video_id"><?php echo esc_html__('Facebook Video URL', 'addify_videos'); ?></label>
				<input type="text" name="afpv_fb_product_video_id" id="afpv_fb_product_video_id" class="afpv_field_text" value="<?php echo esc_attr($afpv_fb_product_video_id); ?>" />
				<p><?php echo esc_html__('Add facebook video link here, e.g (https://www.facebook.com/facebook/videos/XXXXXXXXXXXXX)', 'addify_videos'); ?></p>
			</div>

			<div class="meta_field_full" id="dailymotion">
				<label for="afpv_dm_product_video_id"><?php echo esc_html__('Dailymotion Video ID', 'addify_videos'); ?></label>
				<input type="text" name="afpv_dm_product_video_id" id="afpv_dm_product_video_id" class="afpv_field_text" value="<?php echo esc_attr($afpv_dm_product_video_id); ?>" />
				<p><?php echo esc_html__('Add dailymotion video id here e.g (x5z1gzv). Do not put complete video URL only enter video ID that come after this URL (https://www.dailymotion.com/embed/video/)', 'addify_videos'); ?></p>
			</div>

			<div class="meta_field_full" id="vimeo">
				<label for="afpv_vm_product_video_id"><?php echo esc_html__('Vimeo Video ID', 'addify_videos'); ?></label>
				<input type="text" name="afpv_vm_product_video_id" id="afpv_vm_product_video_id" class="afpv_field_text" value="<?php echo esc_attr($afpv_vm_product_video_id); ?>" />
				<p><?php echo esc_html__('Add vimeo video id here e.g (217936008). Do not put complete video URL only enter video ID that come after this URL (https://vimeo.com/)', 'addify_videos'); ?></p>
			</div>

			<div class="meta_field_full" id="metacafe">
				<label for="afpv_mc_product_video_id"><?php echo esc_html__('Metacafe Video ID', 'addify_videos'); ?></label>
				<input type="text" name="afpv_mc_product_video_id" id="afpv_mc_product_video_id" class="afpv_field_text" value="<?php echo esc_attr($afpv_mc_product_video_id); ?>" />
				<p><?php echo esc_html__('Add metacafe video id here e.g (11858937/top-benefits-of-woocommerce/). Do not put complete video URL only enter video ID that come after this URL (http://www.metacafe.com/watch/)', 'addify_videos'); ?></p>
			</div>

			<div class="meta_field_full" id="custom">
				
				
					
				<div class="imgdis" id="afpv-videp-id">
					<?php if (!empty($afpv_cus_product_video_id)) { ?>
					<label for="afpv_cus_product_video_id"><?php echo esc_html__('Current Video', 'addify_videos'); ?></label>
					<video  frameborder="0" controls width="500">
						<source src="<?php echo esc_url($afpv_cus_product_video_id); ?>" type="video/mp4">
					</video>
					<?php } ?>
				</div>
				
				<label for="afpv_cus_product_video_id"><?php echo esc_html__('Custom Video', 'addify_videos'); ?></label>
				<input type="hidden" value="<?php echo esc_url($afpv_cus_product_video_id); ?>" name="afpv_cus_product_video_id" id="afpv_video_url" class="login_title">
				<input onClick="afpv_video()"   type="button" name="upload-btn" id="upload-video-btn" class="button-secondary" value="<?php echo esc_html__('Upload Video', 'addify_videos'); ?>">
				
			</div>

			<div class="meta_field_full">
				
				
				
				<div class="imgdis" id="logodisplay">
					
					<?php if (!empty($afpv_product_video_thumb)) { ?>
					<label for="afpv_product_video_thumb"><?php echo esc_html__('Current Video Thumbnail', 'addify_videos'); ?></label>
					<img src="<?php echo esc_url($afpv_product_video_thumb); ?>" width="200" />
					<?php } ?>
				
				</div>
				
				

				<label for="afpv_product_video_thumb"><?php echo esc_html__('Video Thumbnail', 'addify_videos'); ?></label>
				<input type="hidden" value="<?php echo esc_url($afpv_product_video_thumb); ?>" name="afpv_product_video_thumb" id="afpv_thumb_url" class="login_title">
				<input onClick="afpv_image()" type="button" name="upload-btn" id="upload-image-btn" class="button-secondary" value="<?php echo esc_html__('Upload Image', 'addify_videos'); ?>">
				<input onClick="afpv_clear_image()" type="button" name="upload-btn" id="clear-image-btn" class="button-secondary" value="<?php echo esc_html__('Remove Image', 'addify_videos'); ?>">
				<p><?php echo esc_html__('This thumbnail will be shown in the product gallery, when you click on it video will played in a popup.', 'addify_videos'); ?></p>
				
			</div>

			<div class="meta_field_full">
				
				<label for="afpv_vm_product_video_id"><?php echo esc_html__('Attach With Products', 'addify_videos'); ?></label>
				<select class="select_box wc-enhanced-select afpv_applied_products" name="afpv_applied_products[]" id="afpv_applied_products"  multiple='multiple'>
						<?php

						$args = array(
							'post_type' => 'product',
							'post_status' => 'publish',
							'numberposts' => -1
						);
						$pros = get_posts($args);

						foreach ($pros as $pro) {
							?>
							<option value="<?php echo intval($pro->ID); ?>" 
								<?php 
								if (!empty($afpv_applied_products) && in_array($pro->ID, $afpv_applied_products)) { 
									echo 'selected'; } 
								?>
									>
								<?php echo esc_attr($pro->post_title); ?>
									
							</option>
						<?php } ?>
					</select>
					<p><?php echo esc_html__('Select products with which you want to attach these videos.', 'addify_videos'); ?></p>
				
			</div>


			<?php
		}


	}

	new Addify_Product_Videos_Admin();

}
