<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Nineteen
 * @since 1.0.0
 */
?> 

<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" /> 
	<link rel="profile" href="https://gmpg.org/xfn/11" />
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,300i,400,400i,600,600i,700,700i,900,900i&display=swap" rel="stylesheet"> 
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/font-awesome.min.css">
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/wordpress.css"> 
<?php wp_head(); ?>
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/responsive.css">
<script src="<?php echo get_template_directory_uri(); ?>/js/jquery.min.js"></script>
<script src="<?php echo get_template_directory_uri(); ?>/js/popper.min.js"></script>
<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js"></script>
<script src="<?php echo get_template_directory_uri(); ?>/js/jquery.extra.js"></script>

	
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div class="wrapper">

<!--Header Start-->
<header class="header">
	<div class="container clearfix">
    	<div class="logo"><a class="btn btn-topmenu d-lg-none" href="javascript:void(0)"><span class="menu-bar"></span></a> <?php the_custom_logo(); ?></div>
        <div id="MainMenu" class="top-menu">
            <div class="menu-logo d-lg-none"><h1><a href="<?php echo esc_url( home_url( '/home/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1></div>
            <div id="NavMenu">
                <nav> 
                    <?php
			wp_nav_menu(
				array(
					'theme_location' => 'menu-top', 
					'items_wrap'     => '<ul id="%1$s" >%3$s</ul>',
				)
			);
			 
   		echo '<ul class="account_auction"><li><a href="'.home_url('/my-account/').'"   class="myaccountlink  "    ><img src="'.get_template_directory_uri().'/images/my-account.png" alt="My Account"><span>My Account</span></a></li>';
       	 ?>
             <li><a class=" fagavellink" href="#"  ><img src="<?php echo get_template_directory_uri(); ?>/images/auction.png" alt="" /><span> Auction Lots</span></a>
             	<ul class="submenu">
             		<li><a href="<?php echo esc_url( home_url( '/home/' ) ); ?>">Home</a></li><li><a href="<?php echo esc_url( home_url( '/auctions/' ) ); ?>">Lots</a></li><li><a href="<?php echo esc_url( home_url( '/rules/' ) ); ?>">Rules</a></li>
             	</ul></li> </nav>
            </div>                    
        </div>
    </div>
</header>
<!--Header End-->

<!--Content Start-->
<div id="content" class="site-content">
	<div class="container">
