<?php

if ( !defined('ABSPATH') ) {

	exit; // Exit if accessed directly.

}

if ( !class_exists('PPS_Password_Protected_Backend_Controller') ) {

	class PPS_Password_Protected_Backend_Controller {

		protected $controller;

		public function __construct() {

			$this->controller = PPS_Password_Protected_Controller::instance();

			add_action('admin_menu', array($this, 'pps_add_menu_page'));

			add_action('admin_init', array($this, 'pps_register_settings'));

			add_filter('woocommerce_screen_ids', array($this, 'pps_screen_ids' ), 10, 1);

			add_action('admin_enqueue_scripts', array($this, 'pps_enqueue_scripts'));

		}

		public function pps_add_menu_page() {

			add_menu_page(esc_html__('Password Protected', 'password-protected'), esc_html__('Password Protected', 'password-protected'), 'manage_options', 'pps-password-protected', array($this, 'pps_menu_page_callback'), 'dashicons-store', 57);

			add_submenu_page('pps-password-protected', esc_html__('Password Protected', 'password-protected'), esc_html__('General Settings', 'password-protected'), 'manage_options', 'pps-password-protected', array($this, 'pps_menu_page_callback'));

			add_submenu_page('pps-password-protected', esc_html__('Password Protect Complete Website', 'password-protected'), esc_html__('Complete Protect', 'password-protected'), 'manage_options', 'pps-protect-complete', array($this, 'pps_complete_store_callback'));

			add_submenu_page('pps-password-protected', esc_html__('Password Protected Login Form Settings', 'password-protected'), esc_html__('Form Settings', 'password-protected'), 'manage_options', 'pps-form-settings', array($this, 'pps_form_settings_callback'));

		}

		public function pps_register_settings() {

			register_setting('pps-store-general-settings', 'pps_password_protected_enable');

			register_setting('pps-store-general-settings', 'pps_password_protected_days');

			register_setting('pps-store-general-settings', 'pps_password_protected_countries');

			

			register_setting('pps-store-complete-settings', 'pps_password_protected_whole_site');

			register_setting('pps-store-complete-settings', 'pps_password_protected_passwords');

			

			register_setting('pps-store-form-settings', 'pps_login_form_above_text');

			register_setting('pps-store-form-settings', 'pps_login_form_below_text');

			register_setting('pps-store-form-settings', 'pps_login_field_label');

			register_setting('pps-store-form-settings', 'pps_login_field_placeholder');

			register_setting('pps-store-form-settings', 'pps_login_button_text');

			register_setting('pps-store-form-settings', 'pps_password_protected_form_type');

			register_setting('pps-store-form-settings', 'pps_form_background_type');

			register_setting('pps-store-form-settings', 'pps_form_background_color');

			register_setting('pps-store-form-settings', 'pps_form_page_color');

			register_setting('pps-store-form-settings', 'pps_form_text_color');

			register_setting('pps-store-form-settings', 'pps_form_button_bgcolor');

			register_setting('pps-store-form-settings', 'pps_form_bg_image');

			register_setting('pps-store-form-settings', 'pps_form_bg_opacity');			

		}

		public function pps_menu_page_callback() {

			PPS_Password_Protected_Settings::pps_general_settings();

		}

		public function pps_form_settings_callback() {

			PPS_Password_Protected_Settings::pps_form_settings();

		}

		public function pps_complete_store_callback() {

			PPS_Password_Protected_Settings::pps_complete_settings();

		}

		public function pps_screen_ids( $screen_ids ) {

			$custom = array('toplevel_page_pps-password-protected');

			$screen_ids = array_merge($custom, $screen_ids);

			return $screen_ids;

		}

		public function pps_enqueue_scripts() {

			global $post_type;

			if ( isset($_GET['page']) && 'pps-form-settings' == $_GET['page'] ) {

				wp_enqueue_style('wp-color-picker');

				wp_enqueue_script('wp-color-picker');

				if ( function_exists('wp_enqueue_media') ) {

					wp_enqueue_media();

				} else {

					wp_enqueue_style('thickbox');

					wp_enqueue_script('media-upload');

					wp_enqueue_script('thickbox');

				}

			}

			if ( ( !empty($this->controller->post_types) && !empty($post_type) && in_array($post_type, $this->controller->post_types) ) || ( isset($_GET['page']) && ( 'pps-form-settings' == $_GET['page'] || 'pps-password-protected' == $_GET['page'] || 'pps-protect-complete' == $_GET['page'] ) ) ) {

				wp_enqueue_style('pps-backendcss', WC_PPS_URL . 'assets/css/backend_style.css', array(), '1.0');

				wp_enqueue_script('pps-backendjs', WC_PPS_URL . 'assets/js/backend_script.js', array('jquery'), '1.0');

			}

		}

	}

	new PPS_Password_Protected_Backend_Controller();

}

