<?php

if ( !defined('ABSPATH') ) {

	exit; // Exit if accessed directly.

}

if ( !class_exists('PPS_Password_Protected_Frontend') ) {

	class PPS_Password_Protected_Frontend {

		protected $controller;

		public function __construct() {

			$this->controller = PPS_Password_Protected_Controller::instance();

			add_filter('woocommerce_loop_add_to_cart_link', array($this, 'pps_button_url'), 23, 2 );

			add_filter('woocommerce_is_purchasable', array($this, 'pps_not_purchaseable' ), 23, 2 );

			add_filter('template_include', array($this, 'pps_load_template'), 99, 1 );

			add_action('template_redirect', array($this, 'pps_protected_login_form'));

		}

		public function pps_protected_countries() {

			$location = WC_Geolocation::geolocate_ip();

			$country = $location['country'];

			$countries = get_option('pps_password_protected_countries');

			if ( !empty($countries) && !empty($country) && in_array($country, $countries) ) {

				return true;

			} elseif ( !empty($countries) && !empty($country) && !in_array($country, $countries) ) {

				return false;

			} else {

				return true;

			}

		}

		public function pps_check_password( $password, $id = '', $type ) {

			$passwords = $this->pps_get_passwords( $id, $type );

			if ( !empty( $passwords ) && in_array( $password, $passwords ) ) {

				return true;

			} else {

				return false;

			}

		}

		public function pps_check_password_related_terms( $password, $id = '', $type ) {

			if ( 'product' != get_post_type($id) ) {

				return false;

			}

			$passwords = $this->pps_get_related_terms_passwords( $id );

			if ( !empty( $passwords ) ) {

				foreach ( $passwords as $term_id => $term_passwords ) {

					if ( !empty( $term_passwords ) && in_array( $password, $term_passwords ) ) {

						return $term_id;

					}

				}

			} 

			return false;

		}

		public function pps_protected_login_form() {

			if ( !isset($_POST['pps_protected_login_nonce']) || !isset($_POST['pps_password']) || !wp_verify_nonce( sanitize_text_field( $_POST['pps_protected_login_nonce'] ), 'pps_protected_login_nonce' ) ) {

				return;

			}

			

			$password = wc_clean( $_POST['pps_password'] );

			

			if ( empty($password) ) {

				$this->controller->validation = esc_html__( 'The password field is required.', 'password-protected' );

				return;

			}

			if ( $this->pps_is_protected_complete() ) {

				if ( $this->pps_check_password( $password, '', 'main' ) ) {

					$password = 'main|' . $password . '|main';

					$this->pps_set_password( 'main', $password );

					wp_safe_redirect( add_query_arg( null, null ) );

					exit();

				}

			}

			if ( $this->controller->pps_is_term() ) {

				$term_id = get_queried_object_id();

				if ( $this->pps_check_password( $password, $term_id, 'term' ) ) {

					$password = $term_id . '|' . $password . '|term';

					$this->pps_set_password( $term_id, $password );

					wp_safe_redirect( add_query_arg( null, null ) );

					exit();

				}

				$term = get_term( $term_id );

				if ( !empty($term) && 'product_cat' == $term->taxonomy ) {

					$ancestors = get_ancestors( $term->term_id, 'product_cat', 'taxonomy' );

					if ( !empty($ancestors) ) {

						foreach ( $ancestors as $parent_term ) {

							if ( $this->pps_check_password( $password, $parent_term, 'term' ) ) {

								$password = $parent_term . '|' . $password . '|term';

								$this->pps_set_password( $parent_term, $password );

								wp_safe_redirect( add_query_arg( null, null ) );

								exit();

							}

						}

					}

				}

			} else {

				$post_id = is_home() ? get_option('page_for_posts') : Get_the_ID();

				$post_id = is_shop() ? wc_get_page_id( 'shop' ) : Get_the_ID();

				if ( $this->pps_check_password( $password, $post_id, 'post' ) ) {

					$password = $post_id . '|' . $password . '|post';

					$this->pps_set_password( $post_id, $password );

					wp_safe_redirect( add_query_arg( null, null ) );

					exit();

				}

				$term_id = $this->pps_check_password_related_terms( $password, $post_id, 'post' );

				if ( $term_id ) {

					$password = $term_id . '|' . $password . '|term';

					$this->pps_set_password( $term_id, $password );

					wp_safe_redirect( add_query_arg( null, null ) );

					exit();

				}

			}

			$this->controller->validation = esc_html__( 'Enter a valid password, please try again.', 'password-protected' );

		}

		public function pps_set_password( $id, $password ) {

			

			require_once ABSPATH . WPINC . '/class-phpass.php';		

			$hashing = new PasswordHash( 8, true );



			$expiry_days = get_option( 'pps_password_protected_days', 10 );

			$expire = apply_filters( 'pps_password_protected_days', time() + $expiry_days * DAY_IN_SECONDS );

			$referrer = wp_get_referer();	

			if ( $referrer ) {

				$secure = ( 'https' === parse_url( $referrer, PHP_URL_SCHEME ) ) ? true : false;

			} else {

				$secure = false;

			}



			setcookie( PPS_PROTECTED_COOKIE . COOKIEHASH . $id, $hashing->HashPassword( $password ), $expire, COOKIEPATH, COOKIE_DOMAIN, $secure );

		}

		public function pps_is_password_logged_in( $id, $type ) {       

			

			if ( !isset( $_COOKIE[PPS_PROTECTED_COOKIE . COOKIEHASH . $id] ) ) {

				return false;

			}

			

			require_once ABSPATH . WPINC . '/class-phpass.php';

			$hashing = new PasswordHash( 8, true );



			$hash = wp_unslash( wc_clean( $_COOKIE[ PPS_PROTECTED_COOKIE . COOKIEHASH . $id ] ) );

			if ( 0 !== strpos( $hash, '$P$B' ) ) {

				return false;

			}

			

			$passwords = $this->pps_get_passwords( $id, $type );

			if ( !empty( $passwords ) ) {

				foreach ( $passwords as $password ) {

					$password = $id . '|' . $password . '|' . $type;

					if ( $hashing->CheckPassword( $password, $hash ) ) {

						return true;

					}

				}

			}

			if ( 'post' == $type && 'product' == get_post_type($id) ) {

				$passwords = $this->pps_get_related_terms_passwords( $id );

				if ( !empty( $passwords ) ) {

					foreach ( $passwords as $term_id => $term_passwords ) {

						foreach ( $term_passwords as $term_password ) {

							$password = $term_id . '|' . $term_password . '|term';

							if ( $hashing->CheckPassword( $password, $hash ) ) {

								return true;

							}

						}

					}

				} 

			}

			if ( 'term' == $type ) {

				$term = get_term( $id );

				if ( !empty($term) && 'product_cat' == $term->taxonomy ) {

					$ancestors = get_ancestors( $term->term_id, 'product_cat', 'taxonomy' );

					if ( !empty($ancestors) ) {

						foreach ( $ancestors as $parent_term ) {

							$passwords = $this->pps_get_passwords( $parent_term, $type );

							if ( 'yes' == get_term_meta($parent_term, 'pps_password_protected_enable', true) && !empty($passwords) ) {

								foreach ( $passwords as $term_id => $term_passwords ) {

									foreach ( $term_passwords as $term_password ) {

										$password = $term_id . '|' . $term_password . '|term';

										if ( $hashing->CheckPassword( $password, $hash ) ) {

											return true;

										}

									}

								}

							}

						}

					}

				}

			}

			unset($_COOKIE[PPS_PROTECTED_COOKIE . COOKIEHASH . $id]);

			return false;

		}

		public function pps_get_passwords( $id = '', $type ) {

			if ( 'main' == $type && 'yes' ==  get_option('pps_password_protected_whole_site') ) {

				return (array) get_option('pps_password_protected_passwords');

			} elseif ( 'term' == $type && 'yes' == get_term_meta($id, 'pps_password_protected_enable', true) ) {

				return (array) get_term_meta($id, 'pps_password_protected_passwords', true);

			} elseif ( 'post' == $type && 'yes' == get_post_meta($id, 'pps_password_protected_enable', true) ) {

				return (array) get_post_meta($id, 'pps_password_protected_passwords', true);

			} else {

				return false;

			}

		}

		public function pps_are_protected_ancestors( $term_id, $object_type, $resource_type ) {

			$ancestors = get_ancestors( $term_id, $object_type, $resource_type );

			if ( !empty($ancestors) ) {

				foreach ( $ancestors as $parent_term ) {

					if ( 'yes' == get_term_meta($parent_term, 'pps_password_protected_enable', true) ) {

						if ( $this->pps_is_password_logged_in($parent_term, 'term') ) {

							return false;

						} else {

							return true;

						}

					}

				}

			}

		}

		public function pps_is_post_protected( $post_id ) {

			if ( 'yes' == get_post_meta($post_id, 'pps_password_protected_enable', true) ) {

				if ( $this->pps_is_password_logged_in($post_id, 'post') ) {

					return false;

				} else {

					return true;

				}

			} else {

				$is_protceetd = false;

				if ( 'product' == get_post_type($post_id) ) {

					$terms = get_the_terms ( $post_id, 'product_cat' );

					if ( !is_wp_error($terms) && !empty($terms) ) {

						foreach ( $terms as $term ) {

							if ( 'yes' == get_term_meta($term->term_id, 'pps_password_protected_enable', true) ) {

								if ( $this->pps_is_password_logged_in($term->term_id, 'term') ) {

									return false;

								} else {

									$is_protceetd = true;

								}

							} else {

								if ( $this->pps_are_protected_ancestors( $term->term_id, 'product_cat', 'taxonomy' ) ) {

									$is_protceetd = true;

								}

							}

						}

					}

					$terms = get_the_terms ( $post_id, 'product_tag' );

					if ( !is_wp_error($terms) && !empty($terms) ) {

						foreach ( $terms as $term ) {

							if ( 'yes' == get_term_meta($term->term_id, 'pps_password_protected_enable', true) ) {

								if ( $this->pps_is_password_logged_in($term->term_id, 'term') ) {

									return false;

								} else {

									$is_protceetd = true;

								}

							}

						}

					}

					if ( $is_protceetd ) {

						return $is_protceetd;

					}

				}

			}

			return false;

		}

		public function pps_is_protected_complete() {

			if ( $this->pps_is_password_logged_in( 'main', 'main' ) ) {

				return false;

			}

			return true;

		}

		public function pps_get_related_terms_passwords( $post_id ) {

			$terms = get_the_terms ( $post_id, 'product_cat' );

			$passwords = array();

			if ( !is_wp_error($terms) && !empty($terms) ) {

				foreach ( $terms as $term ) {

					if ( 'yes' == get_term_meta($term->term_id, 'pps_password_protected_enable', true) ) {

						$passwords[$term->term_id] = get_term_meta($term->term_id, 'pps_password_protected_passwords', true);

					} else {

						$ancestors = get_ancestors( $term->term_id, 'product_cat', 'taxonomy' );

						if ( !empty($ancestors) ) {

							foreach ( $ancestors as $parent_term ) {

								if ( 'yes' == get_term_meta($parent_term, 'pps_password_protected_enable', true) ) {

									$passwords[$parent_term] = get_term_meta($parent_term, 'pps_password_protected_passwords', true);

								}

							}

						}

					}

				}

			}

			$terms = get_the_terms ( $post_id, 'product_tag' );

			if ( !is_wp_error($terms) && !empty($terms) ) {

				foreach ( $terms as $term ) {

					if ( 'yes' == get_term_meta($term->term_id, 'pps_password_protected_enable', true) ) {

						$passwords[$term->term_id] = get_term_meta($term->term_id, 'pps_password_protected_passwords', true);

					}

				}

			}

			return $passwords;

		}

		public function pps_is_term_protected( $term_id ) {

			if ( 'yes' == get_term_meta($term_id, 'pps_password_protected_enable', true) ) {

				if ( ! $this->pps_is_password_logged_in($term_id, 'term') ) {

					return true;

				}

			} else {

				$term = get_term( $term_id );

				if ( !empty($term) && 'product_cat' == $term->taxonomy ) {

					$ancestors = get_ancestors( $term->term_id, 'product_cat', 'taxonomy' );

					if ( !empty($ancestors) ) {

						foreach ( $ancestors as $parent_term ) {

							if ( 'yes' == get_term_meta($parent_term, 'pps_password_protected_enable', true) ) {

								if ( ! $this->pps_is_password_logged_in($parent_term, 'term') ) {

									return true;

								}

							}

						}

					}

				}

			}

			return false;

		}

		public function pps_button_url( $button, $product ) {

			$product_id = $product->get_id();

			if ( $this->pps_is_post_protected($product_id) && $this->pps_protected_countries() ) {

				$link = $product->get_permalink();

				$button='<a href="' . esc_url($link) . '" class="button">' . esc_html__('View Product', 'password-protected') . '</a>';

			}

			return $button;

		}

		public function pps_not_purchaseable( $status, $product ) {

			$product_id = $product->get_id();

			if ( $this->pps_is_post_protected($product_id) && $this->pps_protected_countries() ) {

				$status = false;

			}

			return $status;

		}

		public function pps_load_template( $template ) {

			$post_id = get_the_ID();

			$whole_site = get_option('pps_password_protected_whole_site');

			if ( 'yes' == $whole_site && $this->pps_is_protected_complete() && $this->pps_protected_countries() ) {

				$template = $this->pps_replace_template();

			}

			if ( $this->controller->pps_is_term() ) {

				if ( $this->pps_is_term_protected(get_queried_object_id()) && $this->pps_protected_countries() ) {

					$template = $this->pps_replace_template();

				}

			} else {

				if ( is_home() && $this->pps_is_post_protected(get_option('page_for_posts')) && $this->pps_protected_countries() ) {

					$template = $this->pps_replace_template();

				}

				if ( $this->controller->pps_is_post() && $this->pps_is_post_protected($post_id) && $this->pps_protected_countries() ) {

					$template = $this->pps_replace_template();

				}

				if ( is_shop() && $this->pps_is_post_protected(wc_get_page_id( 'shop' )) && $this->pps_protected_countries() ) {

					$template = $this->pps_replace_template();

				}

			}

			return $template;

		}

		public function pps_replace_template() {

			$template = apply_filters('pps_protected_login_template', WC_PPS_DIR . '/includes/pps-login-template.php');

			return $template;

		}

	}

	new PPS_Password_Protected_Frontend();

}

