<?php

if ( !defined('ABSPATH') ) {

	exit; // Exit if accessed directly.

}

if ( !class_exists('PPS_Password_Protected_Controller') ) {

	class PPS_Password_Protected_Controller {

		/**

		 * Holds post_types to be protected.

		 *

		 * @since 1.0.0

		 */

		public $post_types;

		/**

		 * Holds taxonomies to be protected.

		 *

		 * @since 1.0.0

		 */

		public $taxonomies;

		/**

		 * The single instance of the class.

		 *

		 * @since 1.0.0

		 */

		protected static $_instance = null;

		public $validation;

		public function __construct() {

			$this->validation = '';

			$this->post_types = $this->pps_get_posts();

			$this->taxonomies = $this->pps_get_taxonomies();

		}

		public static function instance() {

			if ( is_null( self::$_instance ) ) {

				self::$_instance = new self();

			}

			return self::$_instance;

		}

		public function pps_get_posts() {

			$post_types = array('product', 'page');

			return apply_filters('pps_password_protected_post_types', $post_types );

		}

		public function pps_get_taxonomies() {

			$taxonomies = array('product_cat', 'product_tag');

			return apply_filters('pps_password_protected_taxonomies', $taxonomies);

		}

		public function pps_is_term() {

			if ( !empty($this->taxonomies) ) {

				if ( is_tax( $this->taxonomies, '' ) ) {

					return true;

				}

			}

			return false;

		}

		public function pps_is_post() {

			if ( !empty($this->post_types) ) {

				if ( is_singular( $this->post_types ) ) {

					return true;

				}

			}

			return false;

		}

	}

	new PPS_Password_Protected_Controller();

}

