<?php
if ( !defined('ABSPATH') ) {
	exit; // Exit if accessed directly.
}
if ( !class_exists('PPS_Password_Protected_Posts') ) {
	class PPS_Password_Protected_Posts {
		protected $post_types;
		public function __construct() {
			$controller = PPS_Password_Protected_Controller::instance();
			$this->post_types = $controller->post_types;
			add_action('add_meta_boxes', array($this, 'pps_custom_meta_box'));
			add_action('save_post', array($this, 'pps_save_posts'), 10, 1);
		}
		public function pps_custom_meta_box() {
			add_meta_box(
				'pps-password-protected-store', 
				esc_html__('Password Protected.', 'password-protected'), 
				array($this, 'pps_meta_box_callback'), 
				$this->post_types, 
				'normal', 
				'high'
			);
		}
		public function pps_meta_box_callback() {
			global $post;
			$post_id=$post->ID;
			$protected = get_post_meta($post_id, 'pps_password_protected_enable', true);
			$passwords = get_post_meta($post_id, 'pps_password_protected_passwords', true);
			echo '<div class="password-protected-password-protected">';
				wp_nonce_field( 'pps_password_protected_nonce', 'pps_password_protected_nonce');
				echo '<table class="form-table pps-password-protected-settings">';
				echo '<tr>';
					echo '<th><label for="pps_password_protected_enable">' . esc_html__('Password Protected', 'password-protected') . '</label></th>';
					echo '<td><input type="checkbox" name="pps_password_protected_enable" value="yes" ' . checked('yes', $protected, false) . ' id="pps_password_protected_enable"><span>' . esc_html__('Enable password protection for this post.', 'password-protected') . '</span></td>';
					echo '</tr><tr>';
					echo '<th><label for="pps_password_protected_passwords">' . esc_html__('Passwords', 'password-protected') . '</label></th>';
					echo '<td>';
					echo '<div class="pps_password_protected_passwords">';
			if ( !empty($passwords) && is_array($passwords) ) {
				foreach ( $passwords as $password ) {
					echo '<p><input type="text" name="pps_password_protected_passwords[]" value="' . esc_attr($password) . '"><span class="dashicons dashicons-plus pps-add-more-password" class="regular-text"></span><span class="dashicons dashicons-minus pps-remove-password"></span></p>';
				}
			} else {
				echo '<p><input type="text" name="pps_password_protected_passwords[]" value=""><span class="dashicons dashicons-plus pps-add-more-password" class="regular-text"></span><span class="dashicons dashicons-minus pps-remove-password"></span></p>';
			}
					echo '</div>';
					echo '</td>';
					echo '</tr>';
				echo '</table>';
			echo '</div>';
		}
		public function pps_save_posts( $post_id ) {
			//if doing an auto save
			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
				return;
			}
			// if our nonce isn't there, or we can't verify it
			if ( !isset( $_POST['pps_password_protected_nonce'] ) || !wp_verify_nonce( wc_clean($_POST['pps_password_protected_nonce']), 'pps_password_protected_nonce' ) ) {
				return;
			}
			// if current user can't edit this post
			if ( !current_user_can( 'edit_post' ) ) {
				return;
			}
			$post_type = get_post_type($post_id);
			if ( !empty($post_type) && !empty($this->post_types) && in_array($post_type, $this->post_types) ) {
				if ( isset($_POST['pps_password_protected_enable']) ) {
					update_post_meta($post_id, 'pps_password_protected_enable', 'yes');
				} else {
					update_post_meta($post_id, 'pps_password_protected_enable', 'no');
				}
				if ( isset($_POST['pps_password_protected_passwords']) ) {
					$passwords = wc_clean($_POST['pps_password_protected_passwords']);
					$passwords = array_filter($passwords);
					$passwords = array_unique($passwords);
					update_post_meta($post_id, 'pps_password_protected_passwords', $passwords);
				}
			}
		}
	}
	new PPS_Password_Protected_Posts();
}
