<?php

if ( !defined('ABSPATH') ) {

	exit; // Exit if accessed directly.

}

if ( !class_exists('PPS_Password_Protected_Settings') ) {

	class PPS_Password_Protected_Settings {

		

		public static function pps_general_settings() {

			?>

			<div class="wrap">

				<form method="post" action="options.php">

					<?php 

						settings_errors(); 

						settings_fields('pps-store-general-settings'); 

						do_settings_sections('pps-store-general-settings'); 

					?>

					<h1><?php esc_html_e('General Control Settings', 'password-protected'); ?></h1>

					<p><i><?php esc_html_e('Enable modules & set the control settings to password protect the store.', 'password-protected'); ?></i></p>

					<hr/>

					<table class="form-table">

						<tr valign="top">

							<th>

								<label for="pps_password_protected_enable"><?php esc_html_e('Enable Password Protected Store', 'password-protected'); ?></label>

							</th>

							<td>

								<?php $value=get_option('pps_password_protected_enable'); ?>

								<input type="checkbox" name="pps_password_protected_enable" value="yes" id="pps_password_protected_enable" <?php echo checked('yes', $value); ?>>

								<span><i><?php esc_html_e('Enable password protected store functionality.', 'password-protected'); ?></i></span>

							</td>

						</tr>

						<tr>

							<th>

								<label for="pps_password_protected_days"><?php esc_html_e('Expiry Days For Password', 'password-protected'); ?></label>

							</th>

							<td>

								<?php $value=get_option('pps_password_protected_days', 3); ?>

								<input type="number" name="pps_password_protected_days" value="<?php esc_attr_e($value); ?>" id="pps_password_protected_days" class="regular-text">

								<p><i><?php esc_html_e('Enter the password protected days for cookie to remember the password.', 'password-protected'); ?></i></p>

							</td>

						</tr>

						<tr>

							<th>

								<label for="pps_password_protected_countries"><?php esc_html_e('Password Protect For Specific Countries', 'password-protected'); ?></label>

							</th>

							<td>

								<?php 

									$value = get_option('pps_password_protected_countries'); 

									$countries_obj   = new WC_Countries();

									$countries   = $countries_obj->__get('countries');

								?>

								<select name="pps_password_protected_countries[]" id="pps_password_protected_countries" class="wc-enhanced-select regular-text" multiple>

								<?php 

								if ( !empty($countries) ) {

									foreach ( $countries as $key => $country ) {

										$selected = '';

										if ( !empty($value) && in_array($key, $value) ) {

											$selected = 'selected="selected"';

										}

										echo '<option value="' . esc_attr($key) . '" ' . esc_attr($selected) . '>' . esc_html($country) . '</option>';

									}

								}

								?>

								</select>

								<p><i><?php esc_html_e('Enabel password protection for specific countries only.', 'password-protected'); ?></i></p>

							</td>

						</tr>

					</table>

					<?php submit_button(); ?>

				</form>

			</div>

			<?php

		}

		public static function pps_complete_settings() {

			?>

			<div class="wrap">

				<form method="post" action="options.php">

					<?php 

						settings_errors(); 

						settings_fields('pps-store-complete-settings'); 

						do_settings_sections('pps-store-complete-settings'); 

					?>

					<h1><?php esc_html_e('Password Protect Complete Website', 'password-protected'); ?></h1>

					<p><i><?php esc_html_e('Enable the password protection for the complete website.', 'password-protected'); ?></i></p>

					<hr/>

					<table class="form-table">

						<tr>

							<th>

								<label for="pps_password_protected_whole_site"><?php esc_html_e('Password Protect Whole Website?', 'password-protected'); ?></label>

							</th>

							<td>

								<?php $value=get_option('pps_password_protected_whole_site'); ?>

								<input type="checkbox" name="pps_password_protected_whole_site" value="yes" id="pps_password_protected_whole_site" <?php echo checked('yes', $value); ?>>

								<span><i><?php esc_html_e('Enable this option to password protect whole website.', 'password-protected'); ?></i></span>

							</td>

						</tr>

						<tr>

							<th>

								<label for="pps_password_protected_passwords"><?php esc_html_e('Whole Website Passwords', 'password-protected'); ?></label>

							</th>

							<td>

								<div class="pps_password_protected_passwords">

								<?php 

								$passwords = get_option('pps_password_protected_passwords');

								if ( !empty($passwords) && is_array($passwords) ) {

									foreach ( $passwords as $password ) {

										echo '<p><input type="text" name="pps_password_protected_passwords[]" value="' . esc_attr($password) . '" class="regular-text"><span class="dashicons dashicons-plus pps-add-more-password"></span><span class="dashicons dashicons-minus pps-remove-password"></span></p>';

									}

								} else {

									echo '<p><input type="text" name="pps_password_protected_passwords[]" value="" class="regular-text"><span class="dashicons dashicons-plus  pps-add-more-password"></span><span class="dashicons dashicons-minus pps-remove-password"></span></p>';

								} 

								?>

								</div>

							</td>

						</tr>

					</table>

					<?php submit_button(); ?>

				</form>

			</div>

			<?php

		}

		public static function pps_form_settings() {

			?>

			<div class="wrap">

				<form method="post" action="options.php">

					<?php 

						settings_errors(); 

						settings_fields('pps-store-form-settings'); 

						do_settings_sections('pps-store-form-settings'); 

					?>

					<h1><?php esc_html_e('Password Protected Login Form Settings', 'password-protected'); ?></h1>

					<p><i><?php esc_html_e('Cutomize the password protected login form with your personalized settings.', 'password-protected'); ?></i></p>

					<hr/>

					<table class="form-table">

						<tr>

							<th>

								<label for="pps_login_form_above_text"><?php esc_html_e('Description Above Password Login Form', 'password-protected'); ?></label>

							</th>

							<td>

								<?php 

								$the_guides = html_entity_decode(get_option('pps_login_form_above_text'));

								echo wp_kses_post( wp_editor( $the_guides, 

								'pps_login_form_above_text', array(

									'textarea_rows' => 2,

									'textarea_name' =>

									'pps_login_form_above_text'

									)

								) ); 

								?>

								<p><i><?php esc_html_e('Add description or logo image above password protected login form.', 'password-protected'); ?></i></p>

							</td>

						</tr>

						<tr>

							<th>

								<label for="pps_login_form_below_text"><?php esc_html_e('Description Below Password Login Form', 'password-protected'); ?></label>

							</th>

							<td>

								<?php 

								$the_guides = html_entity_decode(get_option('pps_login_form_below_text'));

								echo wp_kses_post( wp_editor( $the_guides, 

								'pps_login_form_below_text', array(

									'textarea_rows' => 2,

									'textarea_name' =>

									'pps_login_form_below_text'

									)

								) ); 

								?>

								<p><i><?php esc_html_e('Add description or logo image below password protected login form.', 'password-protected'); ?></i></p>

							</td>

						</tr>

						<tr>

							<th>

								<label for="pps_login_field_label"><?php esc_html_e('Password Field Label', 'password-protected'); ?></label>

							</th>

							<td>

								<?php $title = get_option('pps_login_field_label'); ?>

								<input type="text" name="pps_login_field_label" id="pps_login_field_label" class="regular-text" value="<?php esc_attr_e($title); ?>">

								<p><i><?php esc_html_e('Enter the password Login field label.', 'password-protected'); ?></i></p>

							</td>

						</tr>

						<tr>

							<th>

								<label for="pps_login_field_placeholder"><?php esc_html_e('Password Field Placeholder', 'password-protected'); ?></label>

							</th>

							<td>

								<?php $title = get_option('pps_login_field_placeholder'); ?>

								<input type="text" name="pps_login_field_placeholder" id="pps_login_field_placeholder" class="regular-text" value="<?php esc_attr_e($title); ?>">

								<p><i><?php esc_html_e('Enter the password Login field placeholder.', 'password-protected'); ?></i></p>

							</td>

						</tr>

						<tr>

							<th>

								<label for="pps_login_button_text"><?php esc_html_e('Password Login Button Text', 'password-protected'); ?></label>

							</th>

							<td>

								<?php $title = get_option('pps_login_button_text'); ?>

								<input type="text" name="pps_login_button_text" id="pps_login_button_text" class="regular-text" value="<?php esc_attr_e($title); ?>">

								<p><i><?php esc_html_e('Enter the password Login field placeholder.', 'password-protected'); ?></i></p>

							</td>

						</tr>

						<tr>

							<th>

								<label for="pps_password_protected_form_type"><?php esc_html_e('Password Login Form Type', 'password-protected'); ?></label>

							</th>

							<td>

								<?php $type =get_option('pps_password_protected_form_type'); ?>

								<select name="pps_password_protected_form_type" id="pps_password_protected_form_type" class="regular-text">

									<option value="default" <?php selected('default', $type); ?>><?php esc_html_e('Default Form', 'password-protected'); ?></option>

									<option value="custom" <?php selected('custom', $type); ?>><?php esc_html_e('Custom Form', 'password-protected'); ?></option>

								</select>

								<p><i><?php esc_html_e('Select the registration & login form type.', 'password-protected'); ?></i></p>

							</td>

						</tr>

						<tr class="pps_form_type">

							<th>

								<label for="pps_form_background_type"><?php esc_html_e('Background Type', 'password-protected'); ?></label>

							</th>

							<td>

								<?php $type =get_option('pps_form_background_type'); ?>

								<select name="pps_form_background_type" id="pps_form_background_type" class="regular-text">

									<option value="color" <?php selected('color', $type); ?>><?php esc_html_e('Background Color', 'password-protected'); ?></option>

									<option value="image" <?php selected('image', $type); ?>><?php esc_html_e('Background Image', 'password-protected'); ?></option>

								</select>

								<p><i><?php esc_html_e('Select registration & login form background type.', 'password-protected'); ?></i></p>

							</td>

						</tr>

						<tr class="pps_form_type">

							<th>

								<label for="pps_form_page_color"><?php esc_html_e('Page Background Color', 'password-protected'); ?></label>

							</th>

							<td>

								<?php $value =get_option('pps_form_page_color'); ?>

								<input type="text" name="pps_form_page_color" id="pps_form_page_color" class="pps_password_protected_color" value="<?php esc_attr_e($value); ?>"> 

								<p><i><?php esc_html_e('Select the registration & login form page background color.', 'password-protected'); ?></i></p>

							</td>

						</tr>

						<tr class="pps_form_type">

							<th>

								<label for="pps_form_background_color"><?php esc_html_e('Form Background Color', 'password-protected'); ?></label>

							</th>

							<td>

								<?php $value =get_option('pps_form_background_color'); ?>

								<input type="text" name="pps_form_background_color" id="pps_form_background_color" class="pps_password_protected_color" value="<?php esc_attr_e($value); ?>"> 

								<p><i><?php esc_html_e('Select the registration & login form popup background color.', 'password-protected'); ?></i></p>

							</td>

						</tr>

						<tr class="pps_form_type">

							<th>

								<label for="pps_form_text_color"><?php esc_html_e('Form Text Color', 'password-protected'); ?></label>

							</th>

							<td>

								<?php $value =get_option('pps_form_text_color'); ?>

								<input type="text" name="pps_form_text_color" id="pps_form_text_color" class="pps_password_protected_color" value="<?php esc_attr_e($value); ?>"> 

								<p><i><?php esc_html_e('Select the registration & login form text color.', 'password-protected'); ?></i></p>

							</td>

						</tr>

						<tr class="pps_form_type">

							<th>

								<label for="pps_form_button_bgcolor"><?php esc_html_e('Login Button Background Color', 'password-protected'); ?></label>

							</th>

							<td>

								<?php $value =get_option('pps_form_button_bgcolor'); ?>

								<input type="text" name="pps_form_button_bgcolor" id="pps_form_button_bgcolor" class="pps_password_protected_color" value="<?php esc_attr_e($value); ?>"> 

								<p><i><?php esc_html_e('Select login button background color.', 'password-protected'); ?></i></p>

							</td>

						</tr>

						<tr class="pps_form_type">

							<th>

								<label for="pps_form_bg_image"><?php esc_html_e('Form Background Image', 'password-protected'); ?></label>

							</th>

							<td>

								<?php 

									$id = get_option('pps_form_bg_image'); 

									$bgimg= !empty($id) ? wp_get_attachment_url($id) : ''; 

								?>

								<input class="pps_form_bg_image" type="hidden" name="pps_form_bg_image" value="<?php echo esc_attr($id); ?>">

								<div class="pps_form_bg_image" style="height: 200px; width: 200px; border: 1px solid #aaa;">

									<?php if ( !is_wp_error($bgimg) && !empty($bgimg) ) { ?>

										<img src="<?php echo esc_url($bgimg); ?>" height="200" width="200" alt="<?php esc_html_e('Background Image', 'password-protected'); ?>"/>

									<?php } ?>

								</div>

								<br>

								<a href="#" class="button button-primary pps_form_bg_image_upload"><?php esc_html_e('Upload Image', 'password-protected'); ?></a>

								<p><i><?php esc_html_e('Page Background image for login/registration form page.', 'password-protected'); ?></i></p>

							</td>

						</tr>

						<tr class="pps_form_type">

							<th>

								<label for="pps_form_bg_opacity"><?php esc_html_e('Form Background Opacity', 'password-protected'); ?></label>

							</th>

							<td>

								<?php $value =get_option('pps_form_bg_opacity'); ?>

								<input type="number" name="pps_form_bg_opacity" id="pps_form_bg_opacity" class="regular-text" min="0" max="1" step="any" value="<?php esc_attr_e($value); ?>"> 

								<p><i><?php esc_html_e('Form background opacity. The value must be between 0 to 1.', 'password-protected'); ?></i></p>

							</td>

						</tr>

					</table>

					<?php submit_button(); ?>

				</form>

			</div>

			<?php

		}

	}

}

