<?php

if ( !defined('ABSPATH') ) {

	exit; // Exit if accessed directly.

}

if ( !class_exists('PPS_Password_Protected_Taxonomies') ) {

	class PPS_Password_Protected_Taxonomies {

		protected $taxonomies;

		public function __construct() {

			$controller = PPS_Password_Protected_Controller::instance();

			$this->taxonomies = $controller->taxonomies;

			if ( !empty($this->taxonomies) ) {

				foreach ( $this->taxonomies as $taxonomy ) {

					add_action( esc_html($taxonomy) . '_add_form_fields', array($this, 'pps_add_new_field'), 10);

					add_action( esc_html($taxonomy) . '_edit_form_fields', array($this, 'pps_edit_new_field'), 10, 1 );

					add_action('edited_' . esc_html($taxonomy), array($this, 'pps_save_new_field'), 10, 2 );

					add_action('created_' . esc_html($taxonomy), array($this, 'pps_save_new_field'), 10, 2 );

				}

			}

		}

		public function pps_add_new_field() {

			wp_nonce_field( 'pps_password_protected_nonce', 'pps_password_protected_nonce');

			?>

			<div class="pps-password-protected">

				<div class="form-field term-pps-password-protected-enable">

					<label for="pps_password_protected_enable"><?php esc_html_e('Password Protect', 'password-protected'); ?></label>

					<input type="checkbox" name="pps_password_protected_enable" value="yes" id="pps_password_protected_enable">

					<span><?php esc_html_e('Enable password protection for this term.', 'password-protected'); ?></span>

				</div>

				<div class="pps_password_protected_passwords">

					<label  for="pps_password_protected_passwords"><?php esc_html_e('Passwords', 'password-protected'); ?></label>

					<p><input type="text" name="pps_password_protected_passwords[]" value="">

					<span class="dashicons dashicons-plus pps-add-more-password"></span>

					<span class="dashicons dashicons-minus pps-remove-password"></span></p>

				</div>

			</div>

			<?php

		}

		public static function pps_edit_new_field( $term ) { 

			$term_id = $term->term_id; 

			$protected=get_term_meta($term_id, 'pps_password_protected_enable', true); 

			$passwords=get_term_meta($term_id, 'pps_password_protected_passwords', true); 

			wp_nonce_field( 'pps_password_protected_nonce', 'pps_password_protected_nonce');

			?>

			<tr class="form-field term-pps-password-protected-wrap">

				<th><?php esc_html_e('Password Protect', 'password-protected'); ?></th>

				<td>

					<input type="checkbox" name="pps_password_protected_enable" value="yes" <?php checked('yes', $protected); ?>>

					<span><i><?php esc_html_e('Enable password protection for this term.', 'password-protected'); ?></i></span>

				</td>

			</tr>

			<tr class="form-field term-pps-password-protected-passwords-wrap">

				<th><?php esc_html_e('Passwords', 'wc-pbc'); ?></th>

				<td>

					<div class="pps_password_protected_passwords">

					<?php 

					if ( !empty($passwords) && is_array($passwords) ) {

						foreach ( $passwords as $password ) {

							echo '<p><input type="text" name="pps_password_protected_passwords[]" value="' . esc_attr($password) . '"><span class="dashicons dashicons-plus pps-add-more-password"></span><span class="dashicons dashicons-minus pps-remove-password"></span></p>';

						}

					} else {

						echo '<p><input type="text" name="pps_password_protected_passwords[]" value=""><span class="dashicons dashicons-plus pps-add-more-password"></span><span class="dashicons dashicons-minus pps-remove-password"></span></p>';

					} 

					?>

					</div>

				</td>

			</tr>

			<?php

		}

		public function pps_save_new_field( $term_id, $term ) {

			if ( !isset( $_POST['pps_password_protected_nonce'] ) || !wp_verify_nonce( wc_clean($_POST['pps_password_protected_nonce']), 'pps_password_protected_nonce' ) ) {

				return;

			}

			if ( isset($_POST['pps_password_protected_enable']) ) {

				update_term_meta($term_id, 'pps_password_protected_enable', 'yes'); 

			} else {

				update_term_meta($term_id, 'pps_password_protected_enable', 'no');

			}

			if ( isset($_POST['pps_password_protected_passwords']) ) {

				$passwords = wc_clean($_POST['pps_password_protected_passwords']);

				$passwords = array_filter($passwords);

				$passwords = array_unique($passwords);

				update_term_meta($term_id, 'pps_password_protected_passwords', $passwords); 

			} else {

				$passwords=array();

				update_term_meta($term_id, 'pps_password_protected_passwords', $passwords); 

			}

		}

	}

	new PPS_Password_Protected_Taxonomies();

}

