<?php

if ( ! defined( 'ABSPATH' ) ) {

	exit; 

}

$controller = PPS_Password_Protected_Controller::instance();

$protected = '';

$loginbuttontext = get_option('pps_login_button_text');

$loginbuttontext = !empty($loginbuttontext) ? $loginbuttontext : esc_html__('Log In', 'password-protected');

$field_label = get_option('pps_login_field_label');

$field_label = !empty($field_label) ? $field_label : esc_html__('Password', 'password-protected');

$field_placeholder = get_option('pps_login_field_label');

if ( 'custom' == get_option('pps_password_protected_form_type') ) {

	$protected = 'ppstore-custom';

	$bgtype = get_option('pps_form_background_type');

	$bgimage = get_option('pps_form_bg_image');

	$bgimage = wp_get_attachment_url( $bgimage );

	$bgcolor = get_option('pps_form_page_color');

	$bgcolor = !empty($bgcolor) ? $bgcolor : '#d00';

	$formcolor = get_option('pps_form_background_color');

	$formcolor = !empty($formcolor) ? $formcolor : '#333';

	$textcolor = get_option('pps_form_text_color');

	$textcolor = !empty($textcolor) ? $textcolor : '#fff';

	$opacity = get_option('pps_form_bg_opacity');

	$buttonbgcolor = get_option('pps_form_button_bgcolor');

	$buttonbgcolor = !empty($buttonbgcolor) ? $buttonbgcolor : '#000';

	?>

<html>

<head>

<meta name="viewport" content= "width=device-width, initial-scale=1.0"> 

	<?php wp_head(); ?>

<style>

	<?php if ( 'image' == $bgtype && !empty($bgimage) ) { ?>

	body {

		background-image: url(<?php echo esc_url($bgimage); ?>);

		background-position: center;

		background-size: cover;

	}

	<?php } else { ?>

	body {

		background: <?php esc_html_e($bgcolor); ?>;

	}

	<?php } ?>



.ppstore-custom .pps-store-form-login {

	background-color: <?php esc_html_e($formcolor); ?>;

	opacity: <?php esc_html_e($opacity); ?>;

	padding: 30px;

	width: 40% !important;

	margin: 3em auto;

}

.pps-store-form-login h2, .pps-store-form-login h1, .pps-store-form-login a, .pps-store-form-login label, .pps-store-form-login p, .pps-store-form-login button {

	color : <?php esc_html_e($textcolor); ?>;

}

.ppstore-custom button{

	background-color: <?php esc_html_e($buttonbgcolor); ?>;

}

.woocommerce-notices-wrapper {

	width: 80%;

	margin: 0 auto;

	padding-top: 30px;

}

@media screen and ( max-width: 767px ) {

	.ppstore-custom .pps-store-form-login {

		width: 100% !important;

	}

}

</style>

</head>

<body>

	<?php 

} else {

	get_header();

	if ( $controller->pps_is_post() ) {

		$GLOBALS['product'] = wc_get_product(Get_the_ID());

	}

}

/*if ( !isset( $_POST['pps_protected_login_nonce'] ) || !wp_verify_nonce( sanitize_text_field( $_POST['pps_protected_login_nonce'] ), 'pps_protected_login_nonce' ) ) {

	unset($_POST);

}*/

?>

<div class="pps-password-protected-store <?php esc_attr_e($protected); ?>" id="pps_customer_login">

	<div class="pps-store-form-login">

		<?php $text_above = get_option('pps_login_form_above_text'); ?>

		<div class="pps_above_form"><?php echo wp_kses_post($text_above); ?></div>

		<form class="woocommerce-form woocommerce-form-login login" action="<?php echo esc_url(add_query_arg( null, null )); ?>" method="post">

			<?php 

				wp_nonce_field( 'pps_protected_login_nonce', 'pps_protected_login_nonce' ); 

			?>

			<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">

				<label for="pps_password"><?php esc_html_e( $field_label, 'password-protected' ); ?>&nbsp;<span class="required">*</span></label>

				<input class="woocommerce-Input woocommerce-Input--text input-text" type="password" name="pps_password" id="pps_password" placeholder="<?php esc_attr_e($field_placeholder, 'password-protected'); ?>" autocomplete="current-password" />

			</p>

			<?php 

			if ( !empty($controller->validation) ) {

				echo '<p class="pps-protected-error">';

				echo esc_html__($controller->validation, 'password-protected');

				echo '</p>';

			}

			?>

			<p class="form-row">

				<?php wp_nonce_field( 'woocommerce-login', 'woocommerce-login-nonce' ); ?>

				<button type="submit" class="woocommerce-Button button" id="pps_password_protect_login" name="login" value="<?php esc_attr_e( $loginbuttontext, 'password-protected' ); ?>"><?php esc_html_e( $loginbuttontext, 'password-protected' ); ?></button>

			</p>

		</form>

		<?php $text_below = get_option('pps_login_form_below_text'); ?>

		<div class="pps_below_form"><?php echo wp_kses_post($text_below); ?></div>

	</div>

</div>

	<?php 

	if ( 'custom' == get_option('pps_password_protected_form_type') ) {

		?>

</body>

</html>

		<?php

	} else { 

		get_footer();

	} 



