<?php

/**

* Plugin Name: Password Protected Categories & Store

* Plugin URI: https://www.codeincept.com/

* Description: Password Protect your Store For WooCommerce.

* Version: 1.0.0

* Author: CodeIncept

* Author URI: https://www.codeincept.com/

* Developer: CodeIncept

* Developer URI: https://www.codeincept.com/

* Text Domain: password-protected

* 

* Woo: 5412621:31d50fa301d9c0529a4f0d0a330982d7

* WC requires at least: 3.3

* WC tested up to: 3.9.2

* 

* Copyright: © 2009-2015 WooCommerce.

* License: GNU General Public License v3.0

* License URI: http://www.gnu.org/licenses/gpl-3.0.html

**/

if ( !defined('ABSPATH') ) {

	exit; // Exit if accessed directly.

} //!defined('ABSPATH')

if ( !defined('WC_PPS_DIR') ) {

	define('WC_PPS_DIR', plugin_dir_path(__FILE__));

}

if ( !defined('WC_PPS_URL') ) {

	define('WC_PPS_URL', plugin_dir_url(__FILE__));

}

if ( !defined('PPS_PROTECTED_COOKIE') ) {

	define('PPS_PROTECTED_COOKIE', 'wp-postpass_' );

}

if ( !class_exists('PPS_Password_Protected_Store') ) {

	class PPS_Password_Protected_Store {

		public function __construct() {

			/**

			 * Check if WooCommerce is installed and active.

			 **/

			if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins'))) ) {

				$this->pps_init();

			} else {

				add_action('admin_notices', array($this, 'pps_admin_notices'));

			}

		}

		public function pps_init() {

			/**        

			* Load language.     

			*/

			if ( function_exists( 'load_plugin_textdomain' ) ) {

				load_plugin_textdomain('password-protected', false, dirname(plugin_basename(__FILE__)) . '/languages/');

			}

			require_once WC_PPS_DIR . '/includes/class-pps-main-controller.php';

			if ( is_admin() ) {

				require_once WC_PPS_DIR . '/includes/class-pps-settings.php';

				require_once WC_PPS_DIR . '/includes/class-pps-backend-controller.php';

				require_once WC_PPS_DIR . '/includes/class-pps-post-settings.php';

				require_once WC_PPS_DIR . '/includes/class-pps-taxonomy-settings.php';

			} else {

				if ( 'yes' == get_option('pps_password_protected_enable') ) {

					require_once WC_PPS_DIR . '/includes/class-pps-frontend.php';

				}

			}

		}

		public function pps_admin_notices() {

			global $pagenow;

			if ( 'plugins.php' === $pagenow ) {

				$class = 'notice notice-error is-dismissible';

				$message = esc_html__('Password Protected Store Plugin needs WooCommerce to be installed and active.', 'password-protected');

				printf('<div class="%1$s"><p>%2$s</p></div>', esc_html($class), esc_html($message));

			}

		}

	}

	new PPS_Password_Protected_Store();

}

