import { Fragment } from 'react';

const icon = (
	<svg
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 512 512"
		width="20"
		height="20"
	>
		<path
			d="M469.331,42.666H277.333V21.333C277.333,9.552,267.781,0,256,0s-21.333,9.552-21.333,21.333v21.333H42.669 c-11.782,0-21.333,9.552-21.333,21.333v341.328c0,11.78,9.551,21.333,21.333,21.333h93.482l-27.23,54.461 c-5.269,10.539-0.998,23.353,9.54,28.622c10.54,5.269,23.353,0.997,28.62-9.542l36.771-73.541h144.296l36.77,73.541 c3.738,7.477,11.271,11.799,19.097,11.799c3.206,0,6.461-0.727,9.523-2.257c10.539-5.269,14.809-18.083,9.54-28.622l-27.23-54.461 h93.482c11.782,0,21.333-9.553,21.333-21.333V63.999C490.664,52.218,481.112,42.666,469.331,42.666z M401.819,179.354 L301.253,279.919c-4.001,4.001-9.428,6.248-15.084,6.248c-5.659,0-11.085-2.249-15.085-6.251l-45.253-45.255l-85.48,85.48 c-4.166,4.167-9.625,6.251-15.084,6.251c-5.46,0-10.92-2.084-15.084-6.251c-8.334-8.33-8.334-21.837-0.001-30.168l100.566-100.566 c4.001-4.001,9.426-6.248,15.084-6.248s11.085,2.247,15.085,6.248l45.253,45.256l85.48-85.48c8.331-8.33,21.839-8.33,30.169,0 C410.15,157.515,410.15,171.022,401.819,179.354z"
			fill="#f63d3d"
		/>
	</svg>
);

export const oneColumnIcon = (
	<svg
		xmlns="http://www.w3.org/2000/svg"
		height="20"
		width="20"
		viewBox="0 0 110 110"
	>
		{[...Array(6).keys()].map(a => (
			<rect width="110" height="10" x="0" y={a * 20} />
		))}
	</svg>
);

export const twoColumnsIcon = (
	<svg
		xmlns="http://www.w3.org/2000/svg"
		height="20"
		width="20"
		viewBox="0 0 110 110"
	>
		{[...Array(6).keys()].map(a => (
			<Fragment>
				<rect width="50" height="10" x="0" y={a * 20} />
				<rect width="50" height="10" x="60" y={a * 20} />
			</Fragment>
		))}
	</svg>
);

export const threeColumnsIcon = (
	<svg
		xmlns="http://www.w3.org/2000/svg"
		height="20"
		width="20"
		viewBox="0 0 110 110"
	>
		{[...Array(6).keys()].map(a => (
			<Fragment>
				<rect width="30" height="10" x="0" y={a * 20} />
				<rect width="30" height="10" x="40" y={a * 20} />
				<rect width="30" height="10" x="80" y={a * 20} />
			</Fragment>
		))}
	</svg>
);

export default icon;
