<?php
/**
 * Scripts and Styles Class
 */
class Assets {

    function __construct() {

        if ( is_admin() ) {
            add_action( 'admin_enqueue_scripts', [ $this, 'register' ], 5 );
        } else {
            add_action( 'wp_enqueue_scripts', [ $this, 'register' ], 5 );
        }
    }

    /**
     * Register our app scripts and styles
     *
     * @return void
     */
    public function register() {
        $this->register_scripts( $this->get_scripts() );
        $this->register_styles( $this->get_styles() );
        wp_localize_script( 'wlr-admin', 'wlr_api', admin_url() . 'admin-ajax.php' );
    }

    /**
     * Register scripts
     *
     * @param  array $scripts
     *
     * @return void
     */
    private function register_scripts( $scripts ) {
        foreach ( $scripts as $handle => $script ) {
            $deps      = isset( $script['deps'] ) ? $script['deps'] : false;
            $in_footer = isset( $script['in_footer'] ) ? $script['in_footer'] : false;
            $version   = isset( $script['version'] ) ? $script['version'] : WLR_VERSION;

            wp_register_script( $handle, $script['src'], $deps, $version, $in_footer );
        }
    }

    /**
     * Register styles
     *
     * @param  array $styles
     *
     * @return void
     */
    public function register_styles( $styles ) {
        foreach ( $styles as $handle => $style ) {
            $deps = isset( $style['deps'] ) ? $style['deps'] : false;

            wp_register_style( $handle, $style['src'], $deps, WLR_VERSION );
        }
    }

    /**
     * Get all registered scripts
     *
     * @return array
     */
    public function get_scripts() {
        $with_min = true;
        $min      = $with_min ? '.min' : '';

        $scripts = [
            'wlr-vendor' => [
                'src'       => WLR_ASSETS . '/js/vendor' . $min . '.js',
                'version'   => filemtime( WLR_PATH . '/assets/js/vendor' . $min . '.js' ),
                'in_footer' => true
            ],
            'wlr-admin' => [
                'src'       => WLR_ASSETS . '/js/admin' . $min . '.js',
                'deps'      => [ 'jquery', 'wlr-vendor' ],
                'version'   => filemtime( WLR_PATH . '/assets/js/admin' . $min . '.js' ),
                'in_footer' => true
            ],
        ];

        return $scripts;
    }

    /**
     * Get registered styles
     *
     * @return array
     */
    public function get_styles() {

        $styles = [
            'wlr-style' => [
                'src' =>  WLR_ASSETS . '/css/style.css'
            ],
            'wlr-admin' => [
                'src' =>  WLR_ASSETS . '/css/admin.css'
            ],
        ];

        return $styles;
    }

}
