<?php
/**
 * WooCommerce Square
 *
 * This source file is subject to the GNU General Public License v3.0
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@woocommerce.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade WooCommerce Square to newer
 * versions in the future. If you wish to customize WooCommerce Square for your
 * needs please refer to https://docs.woocommerce.com/document/woocommerce-square/
 *
 * @author    WooCommerce
 * @copyright Copyright: (c) 2019, Automattic, Inc.
 * @license   http://www.gnu.org/licenses/gpl-3.0.html GNU General Public License v3.0
 */

namespace WooCommerce\Square\API\Requests;

use SkyVerge\WooCommerce\PluginFramework\v5_4_0 as Framework;
use SquareConnect\Model as SquareModel;
use SquareConnect\Api\LocationsApi;
use WooCommerce\Square\API\Request;

defined( 'ABSPATH' ) or exit;

/**
 * WooCommerce Square locations API Request class.
 *
 * @since 2.0.0
 */
class Locations extends Request {


	/**
	 * Initializes a new locations request.
	 *
	 * @since 2.0.0
	 *
	 * @param \SquareConnect\ApiClient $api_client the API client
	 */
	public function __construct( $api_client ) {

		$this->square_api = new LocationsApi( $api_client );
	}


	/**
	 * Sets API method.
	 *
	 * @since 2.0.0
	 */
	public function set_list_locations_data() {

		$this->square_api_method = 'listLocations';
	}


}
