<?php
/**
 * WooCommerce Square
 *
 * This source file is subject to the GNU General Public License v3.0
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@woocommerce.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade WooCommerce Square to newer
 * versions in the future. If you wish to customize WooCommerce Square for your
 * needs please refer to https://docs.woocommerce.com/document/woocommerce-square/
 *
 * @author    WooCommerce
 * @copyright Copyright: (c) 2019, Automattic, Inc.
 * @license   http://www.gnu.org/licenses/gpl-3.0.html GNU General Public License v3.0
 */

namespace WooCommerce\Square\Gateway\API\Responses;

defined( 'ABSPATH' ) or exit;

/**
 * The refund API response object.
 *
 * @since 2.0.0
 *
 * @method \SquareConnect\Model\CreateRefundResponse get_data()
 */
class Refund extends \WooCommerce\Square\Gateway\API\Response {


	/**
	 * Determines if the transaction was approved.
	 *
	 * @since 2.0.0
	 *
	 * @return bool
	 */
	public function transaction_approved() {

		return parent::transaction_approved() && ( 'APPROVED' === $this->get_status_code() || 'PENDING' === $this->get_status_code() );
	}


	/** Getter methods ************************************************************************************************/


	/**
	 * Gets the transaction ID.
	 *
	 * @since 2.0.0
	 *
	 * @return string
	 */
	public function get_transaction_id() {

		return $this->get_data() && $this->get_data()->getRefund() ? $this->get_data()->getRefund()->getId() : '';
	}


	/**
	 * Gets the response status code.
	 *
	 * @since 2.0.0
	 *
	 * @return string
	 */
	public function get_status_code() {

		if ( ! $this->has_errors() && $this->get_data() ) {
			$code = $this->get_data()->getRefund()->getStatus();
		} else {
			$code = parent::get_status_code();
		}

		return $code;
	}


}
