# CreatePaymentRequest

### Description

Creates a payment from the source (nonce, card on file, etc.)  The `PAYMENTS_WRITE_ADDITIONAL_RECIPIENTS` OAuth permission is required to enable application fees.  For more information, see [Payments and Refunds Overview](/payments-api/overview).  For information about application fees in a payment, see [Collect Fees](/payments-api/take-payments-and-collect-fees).

## Properties
Name | Getter | Setter | Type | Description | Notes
------------ | ------------- | ------------- | ------------- | ------------- | -------------
**source_id** | getSourceId() | setSourceId($value) | **string** | The ID for the source of funds for this payment.  This can be a nonce generated by the Payment Form or a card on file made with the Customers API. | 
**idempotency_key** | getIdempotencyKey() | setIdempotencyKey($value) | **string** | A unique string that identifies this CreatePayment request. Keys can be any valid string but must be unique for every CreatePayment request.  Max: 45 characters  See [Idempotency keys](/basics/api101/idempotency) for more information. | 
**amount_money** | getAmountMoney() | setAmountMoney($value) | [**\SquareConnect\Model\Money**](Money.md) | The amount of money to accept for this payment, not including &#x60;tip_money&#x60;.  Must be specified in the smallest denomination of the applicable currency. For example, US dollar amounts are specified in cents. See [Working with monetary amounts](/build-basics/working-with-monetary-amounts) for details.  The currency code must match the currency associated with the business that is accepting the payment. | 
**tip_money** | getTipMoney() | setTipMoney($value) | [**\SquareConnect\Model\Money**](Money.md) | The amount designated as a tip, in addition to &#x60;amount_money&#x60;  Must be specified in the smallest denomination of the applicable currency. For example, US dollar amounts are specified in cents. See [Working with monetary amounts](/build-basics/working-with-monetary-amounts) for details.  The currency code must match the currency associated with the business that is accepting the payment. | [optional] 
**app_fee_money** | getAppFeeMoney() | setAppFeeMoney($value) | [**\SquareConnect\Model\Money**](Money.md) | The amount of money the developer is taking as a fee for facilitating the payment on behalf of the seller.  Cannot be more than 90% of the total amount of the Payment.  Must be specified in the smallest denomination of the applicable currency. For example, US dollar amounts are specified in cents. See [Working with monetary amounts](/build-basics/working-with-monetary-amounts) for details.  The currency code must match the currency associated with the business that is accepting the payment.  For more information about the application fee scenario, see [Collect Fees](/payments-api/take-payments-and-collect-fees). | [optional] 
**autocomplete** | getAutocomplete() | setAutocomplete($value) | **bool** | If set to &#x60;true&#x60;, this payment will be completed when possible. If set to &#x60;false&#x60;, this payment will be held in an approved state until either explicitly completed or canceled. For more information, see [Delayed Payments](/payments-api/take-payments#delayed-payments).  Default: true | [optional] 
**order_id** | getOrderId() | setOrderId($value) | **string** | Associate a previously created order with this payment | [optional] 
**customer_id** | getCustomerId() | setCustomerId($value) | **string** | The ID of the customer associated with the payment. Required if the &#x60;source_id&#x60; refers to a card on file created using the Customers API. | [optional] 
**location_id** | getLocationId() | setLocationId($value) | **string** | The location ID to associate with the payment. If not specified, the default location is used. | [optional] 
**reference_id** | getReferenceId() | setReferenceId($value) | **string** | A user-defined ID to associate with the payment. You can use this field to associate the payment to an entity in an external system. For example, you might specify an order ID that is generated by a third-party shopping cart.  Limit 40 characters. | [optional] 
**verification_token** | getVerificationToken() | setVerificationToken($value) | **string** | An identifying token generated by &#x60;SqPaymentForm.verifyBuyer()&#x60;. Verification tokens encapsulate customer device information and 3-D Secure challenge results to indicate that Square has verified the buyer identity.  See the [SCA Overview](/sca-overview) for more. | [optional] 
**accept_partial_authorization** | getAcceptPartialAuthorization() | setAcceptPartialAuthorization($value) | **bool** | If set to true and charging a Square Gift Card, a payment may be returned with amount_money equal to less than what was requested.  Example, a request for $20 when charging a Square Gift Card with balance of $5 wil result in an APPROVED payment of $5.  You may choose to prompt the buyer for an additional payment to cover the remainder, or cancel the gift card payment.  Cannot be &#x60;true&#x60; when &#x60;autocomplete &#x3D; true  For more information, see [Partial amount with Square gift cards](/payments-api/take-payments#partial-payment-gift-card).  Default: false | [optional] 
**buyer_email_address** | getBuyerEmailAddress() | setBuyerEmailAddress($value) | **string** | The buyer&#39;s e-mail address | [optional] 
**billing_address** | getBillingAddress() | setBillingAddress($value) | [**\SquareConnect\Model\Address**](Address.md) | The buyer&#39;s billing address. | [optional] 
**shipping_address** | getShippingAddress() | setShippingAddress($value) | [**\SquareConnect\Model\Address**](Address.md) | The buyer&#39;s shipping address. | [optional] 
**note** | getNote() | setNote($value) | **string** | An optional note to be entered by the developer when creating a payment  Limit 500 characters. | [optional] 

Note: All properties are protected and only accessed via getters and setters.

[[Back to Model list]](../../README.md#documentation-for-models) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to README]](../../README.md)

