<?php
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SquareConnect\Model;

use \ArrayAccess;
/**
 * SearchOrdersResponse Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://squareup.com/developers
 */
class SearchOrdersResponse implements ArrayAccess
{
    /**
      * Array of property to type mappings. Used for (de)serialization 
      * @var string[]
      */
    static $swaggerTypes = array(
        'order_entries' => '\SquareConnect\Model\OrderEntry[]',
        'orders' => '\SquareConnect\Model\Order[]',
        'cursor' => 'string',
        'errors' => '\SquareConnect\Model\Error[]'
    );
  
    /** 
      * Array of attributes where the key is the local name, and the value is the original name
      * @var string[] 
      */
    static $attributeMap = array(
        'order_entries' => 'order_entries',
        'orders' => 'orders',
        'cursor' => 'cursor',
        'errors' => 'errors'
    );
  
    /**
      * Array of attributes to setter functions (for deserialization of responses)
      * @var string[]
      */
    static $setters = array(
        'order_entries' => 'setOrderEntries',
        'orders' => 'setOrders',
        'cursor' => 'setCursor',
        'errors' => 'setErrors'
    );
  
    /**
      * Array of attributes to getter functions (for serialization of requests)
      * @var string[]
      */
    static $getters = array(
        'order_entries' => 'getOrderEntries',
        'orders' => 'getOrders',
        'cursor' => 'getCursor',
        'errors' => 'getErrors'
    );
  
    /**
      * $order_entries List of [OrderEntries](#type-orderentry) that fit the query conditions. Populated only if `return_entries` was set to `true` in the request.
      * @var \SquareConnect\Model\OrderEntry[]
      */
    protected $order_entries;
    /**
      * $orders List of [Order](#type-order) objects that match query conditions. Populated only if `return_entries` in the request is set to `false`.
      * @var \SquareConnect\Model\Order[]
      */
    protected $orders;
    /**
      * $cursor The pagination cursor to be used in a subsequent request. If unset, this is the final response. See [Pagination](/basics/api101/pagination) for more information.
      * @var string
      */
    protected $cursor;
    /**
      * $errors [Errors](#type-error) encountered during the search.
      * @var \SquareConnect\Model\Error[]
      */
    protected $errors;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initializing the model
     */
    public function __construct(array $data = null)
    {
        if ($data != null) {
            if (isset($data["order_entries"])) {
              $this->order_entries = $data["order_entries"];
            } else {
              $this->order_entries = null;
            }
            if (isset($data["orders"])) {
              $this->orders = $data["orders"];
            } else {
              $this->orders = null;
            }
            if (isset($data["cursor"])) {
              $this->cursor = $data["cursor"];
            } else {
              $this->cursor = null;
            }
            if (isset($data["errors"])) {
              $this->errors = $data["errors"];
            } else {
              $this->errors = null;
            }
        }
    }
    /**
     * Gets order_entries
     * @return \SquareConnect\Model\OrderEntry[]
     */
    public function getOrderEntries()
    {
        return $this->order_entries;
    }
  
    /**
     * Sets order_entries
     * @param \SquareConnect\Model\OrderEntry[] $order_entries List of [OrderEntries](#type-orderentry) that fit the query conditions. Populated only if `return_entries` was set to `true` in the request.
     * @return $this
     */
    public function setOrderEntries($order_entries)
    {
        $this->order_entries = $order_entries;
        return $this;
    }
    /**
     * Gets orders
     * @return \SquareConnect\Model\Order[]
     */
    public function getOrders()
    {
        return $this->orders;
    }
  
    /**
     * Sets orders
     * @param \SquareConnect\Model\Order[] $orders List of [Order](#type-order) objects that match query conditions. Populated only if `return_entries` in the request is set to `false`.
     * @return $this
     */
    public function setOrders($orders)
    {
        $this->orders = $orders;
        return $this;
    }
    /**
     * Gets cursor
     * @return string
     */
    public function getCursor()
    {
        return $this->cursor;
    }
  
    /**
     * Sets cursor
     * @param string $cursor The pagination cursor to be used in a subsequent request. If unset, this is the final response. See [Pagination](/basics/api101/pagination) for more information.
     * @return $this
     */
    public function setCursor($cursor)
    {
        $this->cursor = $cursor;
        return $this;
    }
    /**
     * Gets errors
     * @return \SquareConnect\Model\Error[]
     */
    public function getErrors()
    {
        return $this->errors;
    }
  
    /**
     * Sets errors
     * @param \SquareConnect\Model\Error[] $errors [Errors](#type-error) encountered during the search.
     * @return $this
     */
    public function setErrors($errors)
    {
        $this->errors = $errors;
        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset 
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->$offset);
    }
  
    /**
     * Gets offset.
     * @param  integer $offset Offset 
     * @return mixed 
     */
    public function offsetGet($offset)
    {
        return $this->$offset;
    }
  
    /**
     * Sets value based on offset.
     * @param  integer $offset Offset 
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        $this->$offset = $value;
    }
  
    /**
     * Unsets offset.
     * @param  integer $offset Offset 
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->$offset);
    }
  
    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        } else {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this));
        }
    }
}
