<?php if (!defined('ABSPATH')) {

    exit;

}



 if (isset($_POST['submit']) && wp_verify_nonce($_POST['wp_filemanager_root_nonce_field'], 'wp_filemanager_root_action')) {

     $save = update_option('wp_file_manager_pro_settings',

          array(

            'public_path' => isset($_POST['public_path']) ? htmlentities($_POST['public_path']) : '',

            'fm_syntax_checker' => isset($_POST['fm_syntax_checker']) ? htmlentities($_POST['fm_syntax_checker']) : '',

            'fm_enable_trash' => isset($_POST['fm_enable_trash']) ? htmlentities($_POST['fm_enable_trash']) : '',

            'fm_enable_media_upload' => isset($_POST['fm_enable_media_upload']) ? htmlentities($_POST['fm_enable_media_upload']) : '',

            )

        );

     if ($save) {

         echo '<script>';

         echo 'window.location.href="?page=wp_file_manager_root&status=1"';

         echo '</script>';

     } else {

         echo '<script>';

         echo 'window.location.href="?page=wp_file_manager_root&status=2"';

         echo '</script>';

     }

 }

$settings = get_option('wp_file_manager_pro_settings');

$this->fm_custom_assets();

?>

<div class="wrap rootPageWrap">

<div class="fmInnerWrap">



<h3 class="mainHeading">

<span class="headingIcon"><img src="<?php echo plugins_url('images/root-directory-icon.png', __FILE__); ?>"></span>

<span class="headingText"><?php _e('Settings - Root Directory', 'wp-file-manager-pro'); ?></span>

</h3>



<?php $path = str_replace('\\', '/', ABSPATH); ?>



<form action="" method="post" class="rootDirectoryForm">

<?php  wp_nonce_field('wp_filemanager_root_action', 'wp_filemanager_root_nonce_field'); ?>

<label class="labelHeading"><?php _e('Public Root Path', 'wp-file-manager-pro'); ?></label>



<input name="public_path" type="text" id="public_path" value="<?php echo isset($settings['public_path']) && !empty($settings['public_path']) ? $settings['public_path'] : $path; ?>" class="regular-text fmInput">

<div class="grp_root">

<div class="emText"><?php _e('File Manager Root Path, you can change according to your choice.', 'wp-file-manager-pro'); ?></div>

</div>

<div class="grp_root">

<div class="codeTagEle"><label class="labelHeadingInline">Default:</label> <code><?php echo $path; ?></code></div>



<div class="fmError"><?php _e('Please change this carefully, Wrong path can lead file manager plugin to go down.', 'wp-file-manager-pro'); ?></div>

</div>





<div class="grp_root">

	<label class="labelHeading"><?php _e('Enable Syntax Checker?', 'wp-file-manager-pro'); ?></label>

	<div class="rootTwoColWrap">

	<span class="checkCol">

	<input name="fm_syntax_checker" type="checkbox" id="fm_syntax_checker" value="1" class="regular-text" <?php echo (isset($settings['fm_syntax_checker']) && !empty($settings['fm_syntax_checker']) && $settings['fm_syntax_checker'] == 1) ? 'checked="checked"' : ''; ?>>

	</span>

	<div class="fmError"><?php _e('When the Syntax Checker is enabled, the code updates being made to PHP files will be checked for syntax errors. If a syntax error is found, the updates will not be saved and a message box will appear which will define the error found. This checker will help prevent website downtime issues due to syntax errors.', 'wp-file-manager'); ?></div>

	</div>

</div>



<div class="grp_root">

	<label class="labelHeading"><?php _e('Enable Trash?', 'wp-file-manager-pro'); ?></label>

	<div class="rootTwoColWrap">

	<span class="checkCol">

	<input name="fm_enable_trash" type="checkbox" id="fm_enable_trash" value="1" class="regular-text" <?php echo (isset($settings['fm_enable_trash']) && !empty($settings['fm_enable_trash']) && $settings['fm_enable_trash'] == 1) ? 'checked="checked"' : ''; ?>>

	</span>

	<div class="fmError"><?php _e('After enable trash, your files will go to trash folder.', 'wp-file-manager'); ?></div>

	</div>

</div>



<div class="grp_root">

	<label class="labelHeading"><?php _e('Enable Files Upload to Media Library?', 'wp-file-manager-pro'); ?></label>

	<div class="rootTwoColWrap">

	<span class="checkCol">

	<input name="fm_enable_media_upload" type="checkbox" id="fm_enable_media_upload" value="1" class="regular-text" <?php echo (isset($settings['fm_enable_media_upload']) && !empty($settings['fm_enable_media_upload']) && $settings['fm_enable_media_upload'] == 1) ? 'checked="checked"' : ''; ?>>

	</span>

	<div class="fmError"><?php _e('After enable this, uploaded images, pdfs and zip files will go to media library too.', 'wp-file-manager-pro'); ?></div>

	</div>

</div>



<div class="btnDv"><input type="submit" name="submit" id="submit" class="button button-primary fmCustomBtn" value="Save Changes"></div>



</form>



</div>

</div>