<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>

<?php if(is_user_logged_in()):

global $wp_roles;

/* Attributes starts */

 $shortcodeData = shortcode_atts( array(

        'allowed_roles' => '',

        'access_folder' => '*',

				'write' => 'false',

				'read' => 'true',

				'hide_files' => '',

				'lock_extensions' => '',

				'allowed_operations' => '*',

				'ban_user_ids' => '',

				'view' => 'grid',

				'lang' => 'en',

				'theme' => 'light',

				'dateformat' => 'M d, Y h:i A',

				), $atts );

/* End Attributes */

$opt = get_option('wp_filemanager_options');

$current_user = wp_get_current_user();

$userID = $current_user->ID; 

$user = new WP_User( $userID );		

			// if ( !empty( $user->roles ) && is_array( $user->roles ) ) {

			// 	foreach ( $user->roles as $role ):

			// 		$role;

			// 	endforeach;	

			// }			

			

/* Roles Section */		

$allowedroles = $shortcodeData['allowed_roles'];

if(empty($allowedroles))

{

 $allowedroles = array();

}

else if($allowedroles == '*')

{

 $allowedroles = array();	

   $roles = $wp_roles->get_names();

	foreach($roles as $key => $mkrole)

	{

		$allowedroles[] = $key;

	}

}

else if($allowedroles != '*')

{

  $allowedroles = explode(',',$allowedroles);

}

$newAllowedRoles = $allowedroles;

// patch -- bb press

$fm_permission = false;

$mk_count_u_roles = array_intersect($user->roles,$newAllowedRoles);

if(count($mk_count_u_roles) > 0) {

	$fm_permission = true;

}



$banusers = $shortcodeData['ban_user_ids'];

if(empty($banusers))

{

 $banusersArray = array('0' => '0');	

}

else

{	

$banusersArray = explode(',', $banusers);

}

$folderAccess = isset($_GET['access_folder']) ? $_GET['access_folder'] : $shortcodeData['access_folder'];

/* End Ban Users */

if($fm_permission && !in_array($userID, $banusersArray))

{		

wp_enqueue_style( 'jquery-ui', plugins_url('css/jquery-ui.css', dirname( __FILE__ )));

						wp_enqueue_style( 'elfinder.min', plugins_url('lib/css/elfinder.min.css', dirname( __FILE__ ))); 

						wp_enqueue_style( 'theme', plugins_url('lib/css/theme.css', dirname( __FILE__ )));

						wp_enqueue_script( 'jquery_min', plugins_url('js/jquery-ui.min.js', dirname( __FILE__ )));	

						wp_enqueue_script( 'elfinder_min', plugins_url('lib/js/elfinder.full.js',  dirname( __FILE__ ) ));	

						if(isset($shortcodeData['lang']) && !empty($shortcodeData['lang'])):

						 if($shortcodeData['lang'] != 'en') {

						    wp_enqueue_script( 'fm_lang', plugins_url('lib/js/i18n/elfinder.'.$shortcodeData['lang'].'.js', dirname( __FILE__ ) ));	

						 }

						endif;	

						if(isset($shortcodeData['theme']) && !empty($shortcodeData['theme'])){

							 if($shortcodeData['theme'] != 'default') {

								wp_enqueue_style( 'theme-latest', plugins_url('lib/themes/'.$shortcodeData['theme'].'/css/theme.css',  dirname( __FILE__ ) ));	

						       } 

						}	



wp_enqueue_script( 'codemirror_js', plugins_url('lib/codemirror/lib/codemirror.js', dirname( __FILE__ ) ));						

wp_enqueue_style( 'codemirror_css', plugins_url('lib/codemirror/lib/codemirror.css', dirname( __FILE__ )));

if(!empty($opt['code_editor_theme']) && $opt['code_editor_theme'] != 'default') {

	wp_enqueue_style( 'codemirror_theme', plugins_url('lib/codemirror/theme/'.$opt['code_editor_theme'].'.css', dirname( __FILE__ )));	

}	

wp_enqueue_script( 'fm_htmlmixed', plugins_url('lib/codemirror/mode/htmlmixed/htmlmixed.js', dirname( __FILE__ ) ));

wp_enqueue_script( 'fm_xml', plugins_url('lib/codemirror/mode/xml/xml.js', dirname( __FILE__ ) ));	

wp_enqueue_script( 'fm_css', plugins_url('lib/codemirror/mode/css/css.js', dirname( __FILE__ ) ));	

wp_enqueue_script( 'fm_javascript_js', plugins_url('lib/codemirror/mode/javascript/javascript.js', dirname( __FILE__ ) ));	

wp_enqueue_script( 'fm_clike', plugins_url('lib/codemirror/mode/clike/clike.js', dirname( __FILE__ ) ));

wp_enqueue_script( 'fm_php', plugins_url('lib/codemirror/mode/php/php.js', dirname( __FILE__ ) ));	



if(isset($opt['allow_fullscreen']) && $opt['allow_fullscreen'] == 'yes'):

$filemanagerReturn .='<style>

.ui-dialog.ui-widget.ui-widget-content.ui-corner-all.ui-draggable.std42-dialog.touch-punch.elfinder-dialog.ui-resizable.elfinder-dialog-active.ui-front {

  left: 0 !important;

  width: 100% !important;

}

</style>';

endif; 

?>

<?php 

wp_register_script( "file_manager_pro_shortcode", plugins_url('js/file_manager_pro_shortcode.js', dirname( __FILE__ ) ), array('jquery') );

wp_localize_script( 'file_manager_pro_shortcode', 'fmparam', array(

	'ajaxurl' => (empty($atts)) ? admin_url('admin-ajax.php?action=mk_file_folder_manager') : admin_url('admin-ajax.php?action=mk_file_folder_manager_shortcode'),

	'adminajax' => admin_url('admin-ajax.php'),

	'uploadMaxChunkSize' => (isset($opt['fm_max_upload_size']) && !empty($opt['fm_max_upload_size'])) ? $opt['fm_max_upload_size'] * 1048576 : '1048576000000',

	'lang' => (isset($shortcodeData['lang']) && !empty($shortcodeData['lang'])) ? $shortcodeData['lang'] : 'en',

	'view' => (isset($shortcodeData['view']) && !empty($shortcodeData['view'])) ? $shortcodeData['view'] : 'grid',

	'dateformat' => (isset($shortcodeData['dateformat']) && !empty($shortcodeData['dateformat'])) ? $shortcodeData['dateformat'] : 'M d, Y h:i A',

	'allowed_roles' => $shortcodeData['allowed_roles'],

	'access_folder' => $folderAccess, 

	'write' => $shortcodeData['write'], 

	'read' =>  $shortcodeData['read'], 

	'hide_files' => $shortcodeData['hide_files'],

	'lock_extensions' => $shortcodeData['lock_extensions'], 

	'allowed_operations' => $shortcodeData['allowed_operations'], 

	'ban_user_ids' => $shortcodeData['ban_user_ids'],

	'allow_upload_notifications' => (isset($opt['allow_upload_notifications']) && $opt['allow_upload_notifications'] == 'yes') ? 'yes' : 'no',

	'allow_download_notifications' => (isset($opt['allow_download_notifications']) && $opt['allow_download_notifications'] == 'yes') ? 'yes' : 'no',

	'allow_edit_notifications' => (isset($opt['allow_edit_notifications']) && $opt['allow_edit_notifications'] == 'yes') ? 'yes' : 'no',

	'userID' => $userID,

	'nonce' => wp_create_nonce('wp-file-manager-pro'),

	'code_editor_theme' => (!empty($opt['code_editor_theme']) && $opt['code_editor_theme'] != 'default') ? $opt['code_editor_theme'] : 'default'

	)

);        

wp_enqueue_script( 'file_manager_pro_shortcode' );

$filemanagerReturn .='<div class="wrap_file_manager">

<p class="wrap_file_manager_p"><strong>Welcome: </strong>'.$current_user->display_name.'</p>

<div id="wp_file_manager_front"></div>

</div>';

}

else

{

  $filemanagerReturn .='<p>Sorry, you are not allowed to access this page.</p>';	

}

else:

  $filemanagerReturn .='Please login to access file manager.';

endif;?>