jQuery(document).ready(function () {
  var filepaths = [];
  jQuery("#wp_file_manager")
    .elfinder({
      url: fmparams.ajaxurl + "?action=mk_file_folder_manager",
      uploadMaxChunkSize: fmparams.uploadMaxChunkSize,

      lang: fmparams.lang,
      defaultView: fmparams.view,
      uiOptions: {
        toolbar: fmparams.hide_toolbar ? [] : {},
      },

      contextmenu: {
        files: fmparams.hide_context_menu ? [] : {},
        navbar: fmparams.hide_context_menu ? [] : {},
        cwd: fmparams.hide_context_menu ? [] : {},
      },

      handlers: {
        /* Upload */
        upload: function (event, instance) {
          if (fmparams.allow_upload_notifications == "yes") {
            var filepaths = [];
            var fileNames = [];
            var uploadedFiles = event.data.added;
            for (i in uploadedFiles) {
              var file = uploadedFiles[i];
              filepaths.push(file.url);
              fileNames.push(file.name);
            }
            if (filepaths != "") {
              var data = {
                action: "mk_file_folder_manager_uc",
                uploadedby: fmparams.userID,
                uploadefiles: filepaths,
                uploadedFilesNames: fileNames,
              };
              jQuery.post(fmparams.ajaxurl, data, function (response) {});
            }
          }
        },

        /* Download */
        download: function (event, elfinderInstance) {
          if (fmparams.allow_download_notifications == "yes") {
            var downloadFiles = [];
            var downloadfiles = event.data.files;
            for (i in downloadfiles) {
              var filenames = downloadfiles[i].name;
              downloadFiles.push(filenames);
            }
            if (downloadFiles != "") {
              var data = {
                action: "mk_file_folder_manager_dc",
                downloadedby: fmparams.userID,
                downloadedFiles: downloadFiles,
              };
              jQuery.post(fmparams.ajaxurl, data, function (response) {});
            }
          }
        },
      },

      /* END */
      commandsOptions: {
        edit: {
          mimes: [],

          editors: [
            {
              mimes: [
                "text/plain",
                "text/html",
                "text/javascript",
                "text/css",
                "text/x-php",
                "application/x-php",
              ],

              load: function (textarea) {
                var mimeType = this.file.mime;
                return CodeMirror.fromTextArea(textarea, {
                  mode: mimeType,
                  indentUnit: 4,
                  lineNumbers: true,
                  theme: fmparams.code_editor_theme,
                  viewportMargin: Infinity,
                  lineWrapping: true,
                });
              },

              close: function (textarea, instance) {
                this.myCodeMirror = null;
              },

              save: function (textarea, editor) {
                jQuery(textarea).val(editor.getValue());
                /* Start */
                if (fmparams.allow_edit_notifications == "yes") {
                  var data = {
                    action: "mk_file_folder_manager_fn",
                    editedby: fmparams.userID,
                    file: this.file.name,
                  };
                  jQuery.post(fmparams.ajaxurl, data, function (response) {});
                }
                /* End */
              },
            },
          ],
        },
        quicklook: {
          sharecadMimes: [
            "image/vnd.dwg",
            "image/vnd.dxf",
            "model/vnd.dwf",
            "application/vnd.hp-hpgl",
            "application/plt",
            "application/step",
            "model/iges",
            "application/vnd.ms-pki.stl",
            "application/sat",
            "image/cgm",
            "application/x-msmetafile",
          ],
          googleDocsMimes: [
            "application/pdf",
            "image/tiff",
            "application/vnd.ms-office",
            "application/msword",
            "application/vnd.ms-word",
            "application/vnd.ms-excel",
            "application/vnd.ms-powerpoint",
            "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
            "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
            "application/vnd.openxmlformats-officedocument.presentationml.presentation",
            "application/postscript",
            "application/rtf",
          ],
          officeOnlineMimes: [
            "application/vnd.ms-office",
            "application/msword",
            "application/vnd.ms-word",
            "application/vnd.ms-excel",
            "application/vnd.ms-powerpoint",
            "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
            "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
            "application/vnd.openxmlformats-officedocument.presentationml.presentation",
            "application/vnd.oasis.opendocument.text",
            "application/vnd.oasis.opendocument.spreadsheet",
            "application/vnd.oasis.opendocument.presentation",
          ],
        },
      },
    })
    .elfinder("instance");
  // mac fix
  if (navigator.userAgent.indexOf("Mac OS X") != -1) {
    jQuery("body").addClass("mac");
  } else {
    jQuery("body").addClass("windows");
  }
});
